@extends('Admin.layouts.master')

@section('title','blogs')
@section('css')
<link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css')}}">
@endsection

@section('content')

<!-- Base styles-->
<div class="col-sm-12">
  <div class="card">
    <div class="card-header">
      <h5>Blogs</h5>
      <a class="btn btn-success" href="{{route('Admin.blog.create')}}"> Add Blog</a>

    </div>
    <div class="card-body">
      <div class="table-responsive">
        <table class="display" id="example-style-1">
          <thead>

            <tr>
              <th scope="col">ID</th>
              <th scope="col">Title</th>
              <th scope="col">url name</th>
              <th scope="col">Image</th>
              <th scope="col">Category</th>
              <th scope="col">Created By</th>
              <th scope="col">Action</th>


            </tr>
          </thead>
          <tbody>
            @foreach($blogs as $key=> $blog)
            <tr>
              <td>{{$key +1}}</td>
              <td>{{mb_substr($blog->title,0,20)}}</td>
              <td>{{$blog->url_name}}</td>

              <td> <img style="width:60px;" src="{{asset('images/blog/'.$blog->image)}}"></td>
              <td> {{$blog->category}}</td>
              <td> {{$blog->created_by}}</td>
              <td>
                <button class="btn btn-primary" type="button" data-bs-toggle="modal" data-bs-target="#exampleModalmdo{{$blog->id}}" data-whatever="@mdo"><i class="fa fa-edit"></i></button>
                <button class="btn btn-primary" type="button" data-bs-toggle="modal" data-original-title="test" data-bs-target="#exampleModal{{$blog->id}}"><i class="fa fa-trash-o"></i></button>


              </td>
            </tr>
            <!-- modal edit !-->
            <div class="modal fade" id="exampleModalmdo{{$blog->id}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
              <div class="modal-dialog" role="document"  style="max-width:1024px;">
                <div class="modal-content"  style="max-width:1024px;">
                  <div class="modal-header">
                    <h5 class="modal-title">{{$blog->title}}</h5>
                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                  </div>
                  <div class="modal-body">
                    <form action="{{route('Admin.blog.update',$blog->id)}}" method="post" enctype="multipart/form-data">
                      @csrf
                      @method ('PUT')
                
                
                
                     <div class="row">
                         
                        <div class="col-4">
                          <div class="mb-3">
                            <label class="form-label" for="exampleFormControlInput1">Image Title </label>
                            <input class="form-control" name="img_title" id="exampleFormControlInput1" type="text" placeholder="Image Title" value="{{old('title_en',$blog->img_title)}}">
                          </div>
                        </div>
                            
                        <div class="col-4">
                          <div class="mb-3">
                            <label class="form-label" for="exampleFormControlInput1"> Alt Title </label>
                            <input class="form-control" name="alt_title" id="exampleFormControlInput1" type="text" placeholder="Alt Title" value="{{old('title_en',$blog->alt_title)}}">
                          </div>
                        </div>
                            
                        <div class="col-4">
                          <div class="mb-3">
                            <label class="form-label" for="exampleFormControlInput1"> URL Name </label>
                            <input class="form-control" name="url_name" id="exampleFormControlInput1" type="text" placeholder="URL Name" value="{{old('title_en',$blog->url_name)}}">
                          </div>
                        </div>     
                         
                        <div class="col-12">
                          <div class="mb-3">
                            <label class="form-label" for="exampleFormControlInput1">Small Description in English </label>
                            <textarea class="form-control" name="description_en" id="exampleFormControlTextarea4" rows="2">{{old('description_en',$blog->getTranslation('description','en'))}}</textarea>
                         
                          </div>
                        </div>
                        <div class="col-12">
                          <div class="mb-3">
                            <label class="form-label" for="exampleFormControlInput1">Small Description in Arabic </label>
                            <textarea class="form-control  " name="description_ar" id="exampleFormControlTextarea4" rows="2">{{old('description_ar',$blog->getTranslation('description','ar'))}} </textarea>
                         
                          </div>
                        </div>
                    </div>
                

                      <div class="mb-3">
                        <input type="hidden" id="id" name="id" value="{{$blog->id}}">
                        <label class="col-form-label" for="recipient-name">Title in English </label>
                        <input class="form-control  " type="text" name="title_en" value="{{old('title_en',$blog->getTranslation('title','en'))}}">
                     
                      </div>

                      <div class="mb-3">

                        <label class="col-form-label" for="recipient-name">Title in Arabic </label>
                        <input class="form-control " type="text" name="title_ar" value="{{old('title_ar',$blog->getTranslation('title','ar'))}}">
                       
                      </div>
                      
       <div class="row">
            <div class="col-12">
              <div class="mb-3">
                <label class="form-label" for="exampleFormControlInput1">Meta Description </label>
                <textarea class="form-control " name="meta_description" id="exampleFormControlTextarea4" rows="2">{{old('description_en',$blog->meta_description)}}</textarea>
                
              </div>
            </div>
            <div class="col-12">
              <div class="mb-3">
                <label class="form-label" for="exampleFormControlInput1">Meta Keywords</label>
                <textarea class="form-control" name="meta_kewords" id="exampleFormControlTextarea4" rows="2">{{old('description_en',$blog->meta_kewords)}}</textarea>
              </div>
            </div>
      </div>
      

                      <div class="mb-3">

                        <label class="col-form-label" for="recipient-name">Description in English </label>
                        <textarea class="form-control  ckeditor" name="details_en" id="exampleFormControlTextarea4" rows="3">{{old('details_en',$blog->getTranslation('details','en'))}}</textarea>
                       
                      </div>

                      <div class="mb-3">

                        <label class="col-form-label" for="recipient-name">Description in Arabic</label>
                        <textarea class="form-control ckeditor" name="details_ar" id="exampleFormControlTextarea4" rows="3">{{old('details_ar',$blog->getTranslation('details','ar'))}}</textarea>
                      
                      </div>

                      <div class="mb-3">

                        <label class="col-form-label" for="recipient-name">Category in English </label>
                        <input class="form-control" type="text" name="category_en" value="{{old('category_en',$blog->getTranslation('category','en'))}}">
                      
                      </div>

                      <div class="mb-3">

                        <label class="col-form-label" for="recipient-name">Category in Arabic </label>
                        <input class="form-control" type="text" name="category_ar" value="{{old('category_ar',$blog->getTranslation('category','ar'))}}">
                        
                      </div>
                      <div class="mb-3">
                        <label class="col-form-label" for="recipient-name">image </label>
                        <input class="form-control" name="image" type="file" value="{{$blog->link}}">
                      
                      </div>


                  </div>
                  <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Close</button>
                    <button class="btn btn-primary" type="submit">edit</button>
                  </div>
                  </form>
                </div>
              </div>
            </div>
            <!-- modal delete !-->
            <div class="modal fade" id="exampleModal{{$blog->id}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
              <div class="modal-dialog" role="document">
                <div class="modal-content">
                  <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">delete blog</h5>
                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                  </div>
                  <div class="modal-body">
                    <form method="post" action="{{route('Admin.blog.destroy',$blog->id)}}">
                      @csrf
                      @method('DELETE')
                      <p> Are you sure you want to delete this blog ?</p>
                  </div>
                  <div class="modal-footer">
                    <button class="btn btn-primary" type="button" data-bs-dismiss="modal">Close</button>
                    <button class="btn btn-secondary" type="submit">Delete</button>
                  </div>
                  </form>
                </div>
              </div>
            </div>

            @endforeach
          </tbody>
          <tfoot>
            <tr>
              <th>ID</th>
              <th>Title</th>
              <th>Description</th>
              <th>Image</th>
              <th>Category</th>
              <th>Created By</th>
              <th>Action</th>
            </tr>
          </tfoot>
        </table>

      </div>
    </div>
  </div>
  <!-- Base styles Ends-->
  @endsection

  @section('js')
  <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>
  <script src="{{ asset('../assets/js/datatable/datatables/datatable.custom.js')}}"></script>
  <!-- Plugins JS Ends-->
  <script src="{{ asset('assets/js/tooltip-init.js')}}"></script>
  <script src="https://taqiviolet.com/admin/assets/js/editor/ckeditor/ckeditor.custom.js"></script>
<script src="https://taqiviolet.com/admin/assets/js/editor/ckeditor/ckeditor.js"></script>

  @endsection