<?php $__env->startSection('title'); ?>
    Quiz Questions
<?php $__env->stopSection(); ?>

<?php $__env->startSection('level-2'); ?>
    <a href="<?php echo e(route('admin.course.index')); ?>">Courses (<?php echo e($getQuiez->lesson->unit->course->title); ?>)</a>
<?php $__env->startSection('level-3'); ?>
    
<?php $__env->startSection('level-4'); ?>
    <a href="<?php echo e(route('admin.course.unit.index', $getQuiez->lesson->unit_id)); ?>">Units
        (<?php echo e($getQuiez->lesson->unit->number); ?>)</a>
<?php $__env->startSection('level-5'); ?>
    <a href="<?php echo e(route('admin.course.lesson.index', $getQuiez->lesson->unit_id)); ?>">Lessons
        (<?php echo e($getQuiez->lesson->title); ?>)</a>
<?php $__env->startSection('level-6'); ?>
    Quiz Questions
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('page_title', 'Quiz Questions'); ?>
<?php $__env->startSection('css'); ?>

<!--begin::Page Vendors Styles(used by this page)-->
<link href="<?php echo e(asset('assets/Admin/assets/plugins/custom/datatables/datatables.bundle.css')); ?>" rel="stylesheet"
type="text/css" />
<!--end::Page Vendors Styles-->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex flex-column-fluid">
<!--begin::Container-->
<div class="container">

<!--begin::Card-->
<div class="card card-custom gutter-b">
<div class="card-header flex-wrap border-0 pt-6 pb-0">
    <div class="card-title">
        <h3 class="card-title">
            Quiz Questions
            <i class="fa fa-chevron-right mr-2 ml-2"></i>
            belongs to lesson (<?php echo e($getQuiez->lesson->title); ?>)
        </h3>
    </div>
    <div class="card-toolbar">

        <!--end::Dropdown-->
        <!--begin::Button-->
        
        <a href="<?php echo e(route('admin.course.quizquestion.create', $id)); ?>"
            class="btn btn-primary font-weight-bolder">
            <span class="svg-icon svg-icon-md">
                <!--begin::Svg Icon | path:assets/media/svg/icons/Design/Flatten.svg-->
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                    width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                        <rect x="0" y="0" width="24" height="24" />
                        <circle fill="#000000" cx="9" cy="15" r="6" />
                        <path
                            d="M8.8012943,7.00241953 C9.83837775,5.20768121 11.7781543,4 14,4 C17.3137085,4 20,6.6862915 20,10 C20,12.2218457 18.7923188,14.1616223 16.9975805,15.1987057 C16.9991904,15.1326658 17,15.0664274 17,15 C17,10.581722 13.418278,7 9,7 C8.93357256,7 8.86733422,7.00080962 8.8012943,7.00241953 Z"
                            fill="#000000" opacity="0.3" />
                    </g>
                </svg>
                <!--end::Svg Icon-->
            </span>Add </a>
        
        <!--end::Button-->
    </div>
</div>
<div class="card-body">
    <!--begin: Datatable-->
    <table id="example" class="table table-separate table-head-custom table-checkable">
        <thead>
            <tr>
                <th>#</th>
                <th>Title</th>
                <th>Question</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $quizQuestions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $quizQuestion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e(++$key); ?></td>
                    <td> <?php echo e($quizQuestion->title); ?></td>
                    <td> <?php echo e($quizQuestion->question); ?> </td>
                    <td>
                        
                        <a href="<?php echo e(route('admin.course.quizquestion.show', $quizQuestion->id)); ?>"
                            class="btn btn-sm btn-clean btn-icon " title="show details">
                            <span class="svg-icon svg-icon-md">
                                <i class="fa fa-eye" aria-hidden="true"></i>
                            </span>
                        </a>
                        <a href="<?php echo e(route('admin.course.quizquestion.edit', $quizQuestion->id)); ?>"
                            class="btn btn-sm btn-clean btn-icon " title="Edit details">
                            <span class="svg-icon svg-icon-md">
                                <svg xmlns="http://www.w3.org/2000/svg"
                                    xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px"
                                    viewBox="0 0 24 24" version="1.1">
                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                        <rect x="0" y="0" width="24" height="24" />
                                        <path
                                            d="M8,17.9148182 L8,5.96685884 C8,5.56391781 8.16211443,5.17792052 8.44982609,4.89581508 L10.965708,2.42895648 C11.5426798,1.86322723 12.4640974,1.85620921 13.0496196,2.41308426 L15.5337377,4.77566479 C15.8314604,5.0588212 16,5.45170806 16,5.86258077 L16,17.9148182 C16,18.7432453 15.3284271,19.4148182 14.5,19.4148182 L9.5,19.4148182 C8.67157288,19.4148182 8,18.7432453 8,17.9148182 Z"
                                            fill="#000000" fill-rule="nonzero"
                                            transform="translate(12.000000, 10.707409) rotate(-135.000000) translate(-12.000000, -10.707409) " />
                                        <rect fill="#000000" opacity="0.3" x="5" y="20" width="15"
                                            height="2" rx="1" />
                                    </g>
                                </svg>
                            </span>
                        </a>

                        <a class="btn btn-sm btn-clean btn-icon delete_question" title="Delete"
                            data-original-title="delete" data-name="quizquestion"
                            data-question_id="<?php echo e($quizQuestion->id); ?>">
                            <span class="svg-icon svg-icon-md">
                                <svg xmlns="http://www.w3.org/2000/svg"
                                    xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px"
                                    viewBox="0 0 24 24" version="1.1">
                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                        <rect x="0" y="0" width="24" height="24" />
                                        <path
                                            d="M6,8 L6,20.5 C6,21.3284271 6.67157288,22 7.5,22 L16.5,22 C17.3284271,22 18,21.3284271 18,20.5 L18,8 L6,8 Z"
                                            fill="#000000" fill-rule="nonzero" />
                                        <path
                                            d="M14,4.5 L14,4 C14,3.44771525 13.5522847,3 13,3 L11,3 C10.4477153,3 10,3.44771525 10,4 L10,4.5 L5.5,4.5 C5.22385763,4.5 5,4.72385763 5,5 L5,5.5 C5,5.77614237 5.22385763,6 5.5,6 L18.5,6 C18.7761424,6 19,5.77614237 19,5.5 L19,5 C19,4.72385763 18.7761424,4.5 18.5,4.5 L14,4.5 Z"
                                            fill="#000000" opacity="0.3" />
                                    </g>
                                </svg>
                            </span>
                        </a>
                        
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <!--end: Datatable-->
</div>
</div>
<!--end::Card-->

</div>
<!--end::Container-->
</div>
<!--end::Entry-->


<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>

<!--begin::Page Vendors(used by this page)-->
<script src="<?php echo e(asset('assets/Admin/assets/plugins/custom/datatables/datatables.bundle.js')); ?>"></script>
<!--end::Page Vendors-->
<!--begin::Page Scripts(used by this page)-->
<script src="<?php echo e(asset('assets/Admin/assets/js/pages/crud/datatables/basic/scrollable.js')); ?>"></script>
<!--end::Page Scripts-->

<script>
    $(document).ready(function() {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $('.delete_question').click(function(event) {
            var question_id = $(this).data('question_id');
            var name = $(this).data('name');
            var url = '<?php echo e(route('admin.quizquestion.destroy', ':id')); ?>';
            Swal.fire({
                title: `Are you sure you want to delete ?`,
                text: "If you delete this, it will be gone forever.",
                icon: '',
                padding: '3em',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'yes!'
            }).then((result) => {
                if (result.isConfirmed) {

                    $.ajax({
                        url: url.replace(':id', question_id),
                        type: 'DELETE',
                        data: {

                            question_id: question_id
                        },


                        success: function(res) {
                            if (res == 1) {
                                Swal.fire(
                                    'Deleted!',
                                    `${name} Has Been deleted !`,
                                    'success'
                                ).then(() => {
                                    location.reload();
                                })
                            } else {
                                Swal.fire(
                                    'Error!',
                                    `Error : ${res} !`,
                                    'error'
                                )
                            }
                        },
                        error: function(resp) {
                            Swal.fire(
                                'Error!',
                                `Look At Your Console There is An Error !`,
                                'error'
                            )
                            console.log(resp);
                        }
                    });
                }
            });
        });


    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/active4web/public_html/candly/resources/views/Admin/course/quizquestion/index.blade.php ENDPATH**/ ?>