<?php

use GuzzleHttp\Middleware;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\FaqController;
use App\Http\Controllers\Admin\BlogController;
use App\Http\Controllers\Admin\PageController;
use App\Http\Controllers\Admin\QuizController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\TestController;
use App\Http\Controllers\Admin\UnitController;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\GuideController;
use App\Http\Controllers\Admin\LevelController;
use App\Http\Controllers\Admin\CourseController;
use App\Http\Controllers\Admin\LessonController;
use App\Http\Controllers\Admin\ReviewController;
use App\Http\Controllers\Admin\SellerController;
use App\Http\Controllers\Admin\SliderController;
use App\Http\Controllers\Admin\ContactController;
use App\Http\Controllers\Admin\CountryController;
use App\Http\Controllers\Admin\PackageController;
use App\Http\Controllers\Admin\SectionController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\StudentController;
use App\Http\Controllers\Admin\DownloadController;
use App\Http\Controllers\Admin\MessagesController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\FlashCardController;
use App\Http\Controllers\Admin\LessonFaqController;

use App\Http\Controllers\Admin\SubscribeController;
use App\Http\Controllers\Admin\Auth\AuthController;;

use App\Http\Controllers\Admin\CourseGoalController;
use App\Http\Controllers\Admin\CourseQuizController;

use App\Http\Controllers\Admin\CourseUnitController;
use App\Http\Controllers\Admin\QuizAnswerController;
use App\Http\Controllers\Admin\TestAnswerController;
use App\Http\Controllers\Admin\CandlyLevelController;
use App\Http\Controllers\Admin\CourseLevelController;
use App\Http\Controllers\Admin\FaqCategoryController;
use App\Http\Controllers\Admin\GuideDetailController;
use App\Http\Controllers\Admin\SectionItemController;
use App\Http\Controllers\Admin\UplodedFileController;
use App\Http\Controllers\Admin\CourseLessonController;
use App\Http\Controllers\Admin\LessonReviewController;
use App\Http\Controllers\Admin\QuizQuestionController;
use App\Http\Controllers\Admin\TestQuestionController;
use App\Http\Controllers\Admin\CourseFeatureController;
use App\Http\Controllers\Admin\GuideCategoryController;
use App\Http\Controllers\Admin\RegisterVideoController;
use App\Http\Controllers\Admin\GuidesSubCategoryController;
use App\Http\Controllers\Admin\CourseQuizQuestionController;
use App\Http\Controllers\Admin\DownloadAttachementController;

/*
|--------------------------------------------------------------------------
| Admin Routes
|--------------------------------------------------------------------------
|
| Here is where you can register admin routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "admin" middleware group. Now create something great!
|
*/


//Auth
Route::get('/login', [AuthController::class, 'loginPage'])->name('admin.loginpage');
Route::post('/login', [AuthController::class, 'login'])->name('admin.login');
Route::post('/adminlogout', [AuthController::class, 'logout'])->name('admin.logout');

Route::group(['as' => 'admin.', 'middleware' => 'auth:admin'], function () {
    Route::get('/', [DashboardController::class, 'index'])->name('index');
    Route::get('search', [DashboardController::class, 'search'])->name('search');

    // admins
    Route::group(['prefix' => 'admin', 'as' => 'admin.'], function () {
        Route::get('/', [AdminController::class, 'index'])->name('index');
        Route::get('/create', [AdminController::class, 'create'])->name('create');
        Route::post('/store', [AdminController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [AdminController::class, 'edit'])->name('edit');
        Route::put('/update', [AdminController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [AdminController::class, 'destroy'])->name('destroy');
        Route::get('/changerole/{id}', [AdminController::class, 'changeRolePage'])->name('changerolepage');
        Route::put('/changerole/{id}', [AdminController::class, 'changeRole'])->name('changerole');
    });

    // role
    Route::group(['prefix' => 'role', 'as' => 'role.'], function () {

        Route::get('/', [RoleController::class, 'index'])->name('index');
        Route::get('/create', [RoleController::class, 'create'])->name('create');
        Route::post('/store', [RoleController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [RoleController::class, 'edit'])->name('edit');
        Route::put('/update', [RoleController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [RoleController::class, 'destroy'])->name('destroy');
        Route::put('/addrole', [RoleController::class, 'addRole'])->name('add');
        Route::get('/addpermissionpage/{id}', [RoleController::class, 'addPermissionPage'])->name('addpermissionpage');
        Route::put('/addpermission', [RoleController::class, 'addPermission'])->name('addpermission');
    });

    // packages
    Route::group(['prefix' => 'packages', 'as' => 'packages.'], function () {
        Route::get('/', [PackageController::class, 'index'])->name('index');
        Route::get('/create', [PackageController::class, 'create'])->name('create');
        Route::get('/{package}', [PackageController::class, 'show'])->name('show');
        Route::post('/', [PackageController::class, 'store'])->name('store');
        Route::get('/{package}/edit', [PackageController::class, 'edit'])->name('edit');
        Route::put('/{package}', [PackageController::class, 'update'])->name('update');
        Route::delete('/{package}', [PackageController::class, 'destroy'])->name('destroy');
    });

    // subscribes
    Route::group(['prefix' => 'subscribes', 'as' => 'subscribes.'], function () {
        Route::get('/', [SubscribeController::class, 'index'])->name('index');
        Route::delete('/{subscribe}', [SubscribeController::class, 'destroy'])->name('destroy');
    });

    // students
    Route::group(['prefix' => 'student', 'as' => 'student.'], function () {

        Route::get('/', [StudentController::class, 'index'])->name('index');
        Route::get('/create', [StudentController::class, 'create'])->name('create');
        Route::post('/store', [StudentController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [StudentController::class, 'edit'])->name('edit');
        Route::put('/update', [StudentController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [StudentController::class, 'destroy'])->name('destroy');
        Route::get('/notification/{id}', [StudentController::class, 'notification'])->name('notification');
        Route::post('/send/notification', [StudentController::class, 'sendNotification'])->name('sendnotification');

        Route::get('/import', [StudentController::class, 'import'])->name('import');
        Route::post('/upimport', [StudentController::class, 'upimport'])->name('upimport');
    });

    // messages
    Route::group(['prefix' => 'message', 'as' => 'message.'], function () {

        Route::get('/{id}', [MessagesController::class, 'index'])->name('index');
        Route::post('answer/message', [MessagesController::class, 'answer'])->name('answer');

        Route::delete('/destroy/{id}', [MessagesController::class, 'destroy'])->name('destroy');
    });

    // countries
    Route::group(['prefix' => 'country', 'as' => 'country.'], function () {

        Route::get('/', [CountryController::class, 'index'])->name('index');
        Route::get('/create', [CountryController::class, 'create'])->name('create');
        Route::post('/store', [CountryController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [CountryController::class, 'edit'])->name('edit');
        Route::put('/update', [CountryController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [CountryController::class, 'destroy'])->name('destroy');
        Route::get('/import', [CountryController::class, 'import'])->name('import');
        Route::post('/upimport', [CountryController::class, 'upimport'])->name('upimport');
    });

    // courses
    Route::group(['prefix' => 'course', 'as' => 'course.'], function () {
        Route::get('/', [CourseController::class, 'index'])->name('index');
        Route::get('/search/', [CourseController::class, 'search'])->name('search');
        Route::get('/create', [CourseController::class, 'create'])->name('create');
        Route::post('/store', [CourseController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [CourseController::class, 'edit'])->name('edit');
        Route::put('/update', [CourseController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [CourseController::class, 'destroy'])->name('destroy');

        // levels
        // Route::group(['prefix' => 'level', 'as' => 'level.'], function () {
        //     Route::get('/{courseId}', [CourseLevelController::class, 'index'])->name('index');
        //     Route::get('/{id}', [CourseLevelController::class, 'show'])->name('show')->whereNumber('id');
        //     Route::get('/create/{courseId}', [CourseLevelController::class, 'create'])->name('create');
        //     Route::post('/store', [CourseLevelController::class, 'store'])->name('store');
        //     Route::get('/edit/{id}', [CourseLevelController::class, 'edit'])->name('edit');
        //     Route::put('/update', [CourseLevelController::class, 'update'])->name('update');
        //     Route::delete('/destroy', [CourseLevelController::class, 'destroy'])->name('destroy');
        // });

        // units
        Route::group(['prefix' => 'unit', 'as' => 'unit.'], function () {

            Route::get('/{courseId}', [CourseUnitController::class, 'index'])->name('index');
            Route::get('/{id}', [CourseUnitController::class, 'show'])->name('show')->whereNumber('id');
            Route::get('/search/', [CourseUnitController::class, 'search'])->name('search');
            Route::get('/create/{courseId}', [CourseUnitController::class, 'create'])->name('create');

            Route::post('/store', [CourseUnitController::class, 'store'])->name('store');
            
            Route::get('/edit/{id}', [CourseUnitController::class, 'edit'])->name('edit');
            Route::put('/update', [CourseUnitController::class, 'update'])->name('update');
            Route::delete('/destroy/{id}', [CourseUnitController::class, 'destroy'])->name('destroy');

        });


        // lessons
        Route::group(['prefix' => 'unit/lesson', 'as' => 'lesson.'], function () {
            Route::get('/{unitId}', [CourseLessonController::class, 'index'])->name('index');
            Route::get('/create/{unitId}', [CourseLessonController::class, 'create'])->name('create');
            Route::post('/store', [CourseLessonController::class, 'store'])->name('store');
            Route::get('/edit/{id}', [CourseLessonController::class, 'edit'])->name('edit');
            Route::put('/update', [CourseLessonController::class, 'update'])->name('update');
            Route::delete('/destroy/{id}', [CourseLessonController::class, 'destroy'])->name('destroy');
        });

        // quiz
        Route::group(['prefix' => 'level/unit/quiz', 'as' => 'quiz.'], function () {

            Route::get('/{lessonId}', [CourseQuizController::class, 'index'])->name('index');
            Route::get('/create/{id}', [CourseQuizController::class, 'create'])->name('create');
            Route::post('/store', [CourseQuizController::class, 'store'])->name('store');
            Route::get('/edit/{id}', [CourseQuizController::class, 'edit'])->name('edit');
            Route::put('/update', [CourseQuizController::class, 'update'])->name('update');
            Route::delete('/destroy/{id}', [CourseQuizController::class, 'destroy'])->name('destroy');
        });

        // quiz questions
        Route::group(['prefix' => 'level/unit/quiz/quizquestion', 'as' => 'quizquestion.'], function () {

            Route::get('/{id}', [CourseQuizQuestionController::class, 'index'])->name('index');
            Route::get('/create/{id}', [CourseQuizQuestionController::class, 'create'])->name('create');
            Route::get('/show/{id}', [CourseQuizQuestionController::class, 'show'])->name('show');
            Route::post('/store', [CourseQuizQuestionController::class, 'store'])->name('store');
            Route::get('/edit/{id}', [CourseQuizQuestionController::class, 'edit'])->name('edit');
            Route::put('/update', [CourseQuizQuestionController::class, 'update'])->name('update');
            Route::delete('/destroy/{id}', [CourseQuizQuestionController::class, 'destroy'])->name('destroy');
        });
    });

    //setting
    Route::group(['prefix' => 'setting', 'as' => 'setting.'], function () {
        Route::get('/edit', [SettingController::class, 'edit'])->name('edit');
        Route::put('/update', [SettingController::class, 'update'])->name('update');
    });

    //page
    Route::group(['prefix' => 'page', 'as' => 'page.'], function () {
        Route::get('/', [PageController::class, 'index'])->name('index');
        Route::get('/create', [PageController::class, 'create'])->name('create');
        Route::post('/store', [PageController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [PageController::class, 'edit'])->name('edit');
        Route::put('/update', [PageController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [PageController::class, 'destroy'])->name('destroy');
    });

    ////section
    Route::group(['prefix' => 'section', 'as' => 'section.'], function () {

        Route::get('/', [SectionController::class, 'index'])->name('index');
        Route::get('/create', [SectionController::class, 'create'])->name('create');
        Route::post('/store', [SectionController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [SectionController::class, 'edit'])->name('edit');
        Route::put('/update', [SectionController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [SectionController::class, 'destroy'])->name('destroy');
    });

    ///sectionitem
    Route::group(['prefix' => 'sectionitem', 'as' => 'sectionitem.'], function () {
        Route::get('/', [SectionItemController::class, 'index'])->name('index');
        Route::get('/create', [SectionItemController::class, 'create'])->name('create');
        Route::post('/store', [SectionItemController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [SectionItemController::class, 'edit'])->name('edit');
        Route::put('/update', [SectionItemController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [SectionItemController::class, 'destroy'])->name('destroy');
    });

    //sub page
    Route::group(['prefix' => 'sub', 'as' => 'sub.'], function () {

        //page
        Route::group(['prefix' => 'page', 'as' => 'page.'], function () {
            Route::get('/', [PageController::class, 'index'])->name('index');
            Route::get('/create', [PageController::class, 'create'])->name('create');
            Route::post('/store', [PageController::class, 'store'])->name('store');
            Route::get('/edit/{id}', [PageController::class, 'edit'])->name('edit');
            Route::put('/update', [PageController::class, 'update'])->name('update');
            Route::delete('/destroy/{id}', [PageController::class, 'destroy'])->name('destroy');
        });

        ////section
        Route::group(['prefix' => 'section', 'as' => 'section.'], function () {

            Route::get('/', [SectionController::class, 'index'])->name('index');
            Route::get('/create', [SectionController::class, 'create'])->name('create');
            Route::post('/store', [SectionController::class, 'store'])->name('store');
            Route::get('/edit/{id}', [SectionController::class, 'edit'])->name('edit');
            Route::put('/update', [SectionController::class, 'update'])->name('update');
            Route::delete('/destroy/{id}', [SectionController::class, 'destroy'])->name('destroy');
        });

        ///sectionitem
        Route::group(['prefix' => 'sectionitem', 'as' => 'sectionitem.'], function () {
            Route::get('/', [SectionItemController::class, 'index'])->name('index');
            Route::get('/create', [SectionItemController::class, 'create'])->name('create');
            Route::post('/store', [SectionItemController::class, 'store'])->name('store');
            Route::get('/edit/{id}', [SectionItemController::class, 'edit'])->name('edit');
            Route::put('/update', [SectionItemController::class, 'update'])->name('update');
            Route::delete('/destroy/{id}', [SectionItemController::class, 'destroy'])->name('destroy');
        });
    });

    ////slider
    Route::group(['prefix' => 'slider', 'as' => 'slider.'], function () {

        Route::get('/', [SliderController::class, 'index'])->name('index');
        Route::get('/create', [SliderController::class, 'create'])->name('create');
        Route::post('/store', [SliderController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [SliderController::class, 'edit'])->name('edit');
        Route::put('/update', [SliderController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [SliderController::class, 'destroy'])->name('destroy');
    });

    ////Blog
    Route::group(['prefix' => 'blog', 'as' => 'blog.'], function () {

        Route::get('/', [BlogController::class, 'index'])->name('index');
        Route::get('/create', [BlogController::class, 'create'])->name('create');
        Route::post('/store', [BlogController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [BlogController::class, 'edit'])->name('edit');
        Route::put('/update', [BlogController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [BlogController::class, 'destroy'])->name('destroy');
    });

    /////////contact
    Route::group(['prefix' => 'contact', 'as' => 'contact.'], function () {

        Route::get('/', [ContactController::class, 'index'])->name('index');
        Route::delete('/destroy/{id}', [ContactController::class, 'destroy'])->name('destroy');
    });

    ////coursegoal
    Route::group(['prefix' => 'coursegoal', 'as' => 'coursegoal.'], function () {

        Route::get('/', [CourseGoalController::class, 'index'])->name('index');
        Route::get('/create', [CourseGoalController::class, 'create'])->name('create');
        Route::post('/store', [CourseGoalController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [CourseGoalController::class, 'edit'])->name('edit');
        Route::put('/update', [CourseGoalController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [CourseGoalController::class, 'destroy'])->name('destroy');
    });

    ////coursefeature
    Route::group(['prefix' => 'coursefeature', 'as' => 'coursefeature.'], function () {

        Route::get('/', [CourseFeatureController::class, 'index'])->name('index');
        Route::get('/create', [CourseFeatureController::class, 'create'])->name('create');
        Route::post('/store', [CourseFeatureController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [CourseFeatureController::class, 'edit'])->name('edit');
        Route::put('/update', [CourseFeatureController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [CourseFeatureController::class, 'destroy'])->name('destroy');
    });

    ////registervideo
    Route::group(['prefix' => 'registervideo', 'as' => 'registervideo.'], function () {

        Route::get('/', [RegisterVideoController::class, 'index'])->name('index');
        Route::get('/create', [RegisterVideoController::class, 'create'])->name('create');
        Route::post('/store', [RegisterVideoController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [RegisterVideoController::class, 'edit'])->name('edit');
        Route::put('/update', [RegisterVideoController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [RegisterVideoController::class, 'destroy'])->name('destroy');
    });

    ////FaqCategory
    Route::group(['prefix' => 'faqcategory', 'as' => 'faqcategory.'], function () {

        Route::get('/', [FaqCategoryController::class, 'index'])->name('index');
        Route::get('/create', [FaqCategoryController::class, 'create'])->name('create');
        Route::post('/store', [FaqCategoryController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [FaqCategoryController::class, 'edit'])->name('edit');
        Route::put('/update', [FaqCategoryController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [FaqCategoryController::class, 'destroy'])->name('destroy');
    });

    ////Faq
    Route::group(['prefix' => 'faq', 'as' => 'faq.'], function () {

        Route::get('/', [FaqController::class, 'index'])->name('index');
        Route::get('/create', [FaqController::class, 'create'])->name('create');
        Route::post('/store', [FaqController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [FaqController::class, 'edit'])->name('edit');
        Route::put('/update', [FaqController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [FaqController::class, 'destroy'])->name('destroy');
    });

    //////////Review
    Route::group(['prefix' => 'review', 'as' => 'review.'], function () {

        Route::get('/', [ReviewController::class, 'index'])->name('index');
        Route::get('/create', [ReviewController::class, 'create'])->name('create');
        Route::post('/store', [ReviewController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [ReviewController::class, 'edit'])->name('edit');
        Route::put('/update', [ReviewController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [ReviewController::class, 'destroy'])->name('destroy');
    });

    // levels
    Route::group(['prefix' => 'level', 'as' => 'level.'], function () {

        Route::get('/', [LevelController::class, 'index'])->name('index');
        Route::get('/{id}', [LevelController::class, 'show'])->name('show')->whereNumber('id');
        Route::get('/create', [LevelController::class, 'create'])->name('create');
        Route::post('/store', [LevelController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [LevelController::class, 'edit'])->name('edit');
        Route::put('/update', [LevelController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [LevelController::class, 'destroy'])->name('destroy');
    });

    // units
    Route::group(['prefix' => 'unit', 'as' => 'unit.'], function () {

        Route::get('/', [UnitController::class, 'index'])->name('index');
        Route::get('/{id}', [UnitController::class, 'show'])->name('show')->whereNumber('id');
        Route::get('/search/', [UnitController::class, 'search'])->name('search');
        Route::get('/create', [UnitController::class, 'create'])->name('create');
        Route::post('/store', [UnitController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [UnitController::class, 'edit'])->name('edit');
        Route::put('/update', [UnitController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [UnitController::class, 'destroy'])->name('destroy');
    });

    // lessons
    Route::group(['prefix' => 'lesson', 'as' => 'lesson.'], function () {

        Route::get('/', [LessonController::class, 'index'])->name('index');
        Route::get('/create', [LessonController::class, 'create'])->name('create');
        Route::post('/store', [LessonController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [LessonController::class, 'edit'])->name('edit');
        Route::put('/update', [LessonController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [LessonController::class, 'destroy'])->name('destroy');
    });

    // quiz
    Route::group(['prefix' => 'quiz', 'as' => 'quiz.'], function () {

        Route::get('/', [QuizController::class, 'index'])->name('index');
        Route::get('/create/{id}', [QuizController::class, 'create'])->name('create');
        Route::post('/store', [QuizController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [QuizController::class, 'edit'])->name('edit');
        Route::put('/update', [QuizController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [QuizController::class, 'destroy'])->name('destroy');
    });

    // quiz questions
    Route::group(['prefix' => 'quizquestion', 'as' => 'quizquestion.'], function () {

        Route::get('/{id}', [QuizQuestionController::class, 'index'])->name('index');
        Route::get('/create/{id}', [QuizQuestionController::class, 'create'])->name('create');
        Route::get('/show/{id}', [QuizQuestionController::class, 'show'])->name('show');
        Route::post('/store', [QuizQuestionController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [QuizQuestionController::class, 'edit'])->name('edit');
        Route::put('/update', [QuizQuestionController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [QuizQuestionController::class, 'destroy'])->name('destroy');
    });

    // lessonfaq
    Route::group(['prefix' => 'lessonfaq', 'as' => 'lessonfaq.'], function () {

        Route::get('/', [LessonFaqController::class, 'index'])->name('index');

        Route::get('/edit/{id}', [LessonFaqController::class, 'edit'])->name('edit');
        Route::put('/update', [LessonFaqController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [LessonFaqController::class, 'destroy'])->name('destroy');
    });
    // lessonreview
    Route::group(['prefix' => 'lessonreview', 'as' => 'lessonreview.'], function () {

        Route::get('/', [LessonReviewController::class, 'index'])->name('index');
        Route::delete('/destroy/{id}', [LessonReviewController::class, 'destroy'])->name('destroy');
    });



    // flashcards
    Route::group(['prefix' => 'flashcard', 'as' => 'flashcard.'], function () {

        Route::get('/', [FlashCardController::class, 'index'])->name('index');
        Route::get('/create', [FlashCardController::class, 'create'])->name('create');
        Route::post('/store', [FlashCardController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [FlashCardController::class, 'edit'])->name('edit');
        Route::put('/update', [FlashCardController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [FlashCardController::class, 'destroy'])->name('destroy');
    });


    // test
    Route::group(['prefix' => 'test', 'as' => 'test.'], function () {

        Route::get('/', [TestController::class, 'index'])->name('index');
        Route::get('/create', [TestController::class, 'create'])->name('create');
        Route::post('/store', [TestController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [TestController::class, 'edit'])->name('edit');
        Route::put('/update', [TestController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [TestController::class, 'destroy'])->name('destroy');
        Route::get('/import', [TestController::class, 'import'])->name('import');
        Route::post('/upimport', [TestController::class, 'upimport'])->name('upimport');
    });

    // test Question
    Route::group(['prefix' => 'testQuestion', 'as' => 'testQuestion.'], function () {

        Route::get('/', [TestQuestionController::class, 'index'])->name('index');
        Route::get('/show/{id}', [TestQuestionController::class, 'show'])->name('show');
        Route::get('/create', [TestQuestionController::class, 'create'])->name('create');
        Route::post('/store', [TestQuestionController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [TestQuestionController::class, 'edit'])->name('edit');
        Route::put('/update', [TestQuestionController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [TestQuestionController::class, 'destroy'])->name('destroy');
        Route::post('/status', [TestQuestionController::class, 'status'])->name('status');
    });


    // test Answer
    Route::group(['prefix' => 'testAnswer', 'as' => 'testAnswer.'], function () {
        Route::get('/create/{questionid}', [TestAnswerController::class, 'create'])->name('create');
        Route::post('/store', [TestAnswerController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [TestAnswerController::class, 'edit'])->name('edit');
        Route::put('/update', [TestAnswerController::class, 'update'])->name('update');
        Route::get('/destroy/{id}', [TestAnswerController::class, 'destroy'])->name('destroy');
    });

    // quiz Answer
    Route::group(['prefix' => 'quizAnswer', 'as' => 'quizAnswer.'], function () {
        Route::get('/create/{questionid}', [QuizAnswerController::class, 'create'])->name('create');
        Route::post('/store', [QuizAnswerController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [QuizAnswerController::class, 'edit'])->name('edit');
        Route::put('/update', [QuizAnswerController::class, 'update'])->name('update');
        Route::get('/destroy/{id}', [QuizAnswerController::class, 'destroy'])->name('destroy');
    });

    // downloads
    Route::group(['prefix' => 'download', 'as' => 'download.'], function () {

        Route::get('/', [DownloadController::class, 'index'])->name('index');
        Route::get('/create', [DownloadController::class, 'create'])->name('create');
        Route::post('/store', [DownloadController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [DownloadController::class, 'edit'])->name('edit');
        Route::put('/update', [DownloadController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [DownloadController::class, 'destroy'])->name('destroy');
    });

    // downloadattachements
    Route::group(['prefix' => 'downloadattachement', 'as' => 'downloadattachement.'], function () {

        Route::get('/', [DownloadAttachementController::class, 'index'])->name('index');
        Route::get('/create', [DownloadAttachementController::class, 'create'])->name('create');
        Route::post('/store', [DownloadAttachementController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [DownloadAttachementController::class, 'edit'])->name('edit');
        Route::put('/update', [DownloadAttachementController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [DownloadAttachementController::class, 'destroy'])->name('destroy');
    });

    // uploded files
    Route::group(['prefix' => 'uplodedfile', 'as' => 'uplodedfile.'], function () {

        Route::get('/', [UplodedFileController::class, 'index'])->name('index');
        Route::get('/create', [UplodedFileController::class, 'create'])->name('create');
        Route::post('/store', [UplodedFileController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [UplodedFileController::class, 'edit'])->name('edit');
        Route::put('/update', [UplodedFileController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [UplodedFileController::class, 'destroy'])->name('destroy');
    });


    //Guides

    //Category
    Route::group(['prefix' => 'guidecategory', 'as' => 'guidecategory.'], function () {

        Route::get('/', [GuideCategoryController::class, 'index'])->name('index');
        Route::get('/create', [GuideCategoryController::class, 'create'])->name('create');
        Route::post('/store', [GuideCategoryController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [GuideCategoryController::class, 'edit'])->name('edit');
        Route::put('/update', [GuideCategoryController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [GuideCategoryController::class, 'destroy'])->name('destroy');
    });

    // subCategory
    Route::group(['prefix' => 'guidesubcategory', 'as' => 'guidesubcategory.'], function () {

        Route::get('/', [GuidesSubCategoryController::class, 'index'])->name('index');
        Route::get('/create', [GuidesSubCategoryController::class, 'create'])->name('create');
        Route::post('/store', [GuidesSubCategoryController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [GuidesSubCategoryController::class, 'edit'])->name('edit');
        Route::put('/update', [GuidesSubCategoryController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [GuidesSubCategoryController::class, 'destroy'])->name('destroy');
    });

    // guide
    Route::group(['prefix' => 'guide', 'as' => 'guide.'], function () {

        Route::get('/', [GuideController::class, 'index'])->name('index');
        Route::get('/create', [GuideController::class, 'create'])->name('create');
        Route::post('/store', [GuideController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [GuideController::class, 'edit'])->name('edit');
        Route::put('/update', [GuideController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [GuideController::class, 'destroy'])->name('destroy');
    });

    // guideDetail
    Route::group(['prefix' => 'guidedetail', 'as' => 'guidedetail.'], function () {

        Route::get('/', [GuideDetailController::class, 'index'])->name('index');
        Route::get('/create', [GuideDetailController::class, 'create'])->name('create');
        Route::post('/store', [GuideDetailController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [GuideDetailController::class, 'edit'])->name('edit');
        Route::put('/update', [GuideDetailController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [GuideDetailController::class, 'destroy'])->name('destroy');
    });


    // candly level
    Route::group(['prefix' => 'candlylevel', 'as' => 'candlylevel.'], function () {

        Route::get('/', [CandlyLevelController::class, 'index'])->name('index');
        Route::get('/create', [CandlyLevelController::class, 'create'])->name('create');
        Route::post('/store', [CandlyLevelController::class, 'store'])->name('store');
        Route::get('/edit/{id}', [CandlyLevelController::class, 'edit'])->name('edit');
        Route::put('/update', [CandlyLevelController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [CandlyLevelController::class, 'destroy'])->name('destroy');
    });

    Route::resource('sellers', SellerController::class)->except(['show']);
});
