@extends('Front.dashboard.layouts.master')

@section('title')
    Price
@endsection
@section('level-2')
    Prices
@endsection
@section('css')
    <style>
        .default-btn {
            color: white !important;
        }

        .course-icon {
            width: 70px;
            height: 70px;
        }
    </style>
@endsection

@section('content')
    <div id="monthly" class="wrapper-full">
        <div class="row justify-content-center">

            @foreach ($packages as $package)
                <div class="col-lg-4 col-md-6">
                    <div class="single-plans-table">

                        <h3 class="plans-header">{{ $package->name }}</h3>
                        <p class="price">{{ $package->price }} <span> USD</span></p>
                        <div class="full-pricing"><span></span></div>
                        <p class="">{{ $package->description }}</p>

                        <a role="button" class="package-box" data-id="package-{{ $package->id }}">
                            <span id="more-package-{{ $package->id }}">see more ..</span>
                            <span id="less-package-{{ $package->id }}" style="display: none">see less ..</span>
                        </a>

                        <div class="collapse" id="package-{{ $package->id }}">
                            <ul class="plans-features-list">
                                @foreach ($package->courses as $course)
                                    <li><i class="fa-solid fa-check"></i> {{ $course->title }}</li>
                                    <ul class="plans-features-list ps-5">
                                        @foreach ($course->units as $unite)
                                            <li><i class="fa-solid fa-check"></i>Unites: {{ $unite->number }}</li>
                                        @endforeach
                                    </ul>
                                @endforeach
                            </ul>
                            <div class="plans-btn mx-auto">
                                <form action="{{ route('front.dashboard.subscribe') }}" method="post">
                                    @csrf
                                    <input type="text" name="code" placeholder="Code .."
                                        class="form-control my-3 col-12 @error('code') is-invalid fparsley-error parsley-error @enderror">
                                    @error('code')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                            <input type="hidden" name="package_id" value="{{ $package->id }}">
                            <button type="submit" class="btn btn-success col-12">Subscribe</button>
                            </form>
                        </div>
                    </div>
                </div>
        </div>
        @endforeach

    </div>
    </div>

    <div class="opster">
        <div class="overtitle">
            <h1>Everything You Need to Learn English</h1>
            <h2> {{ $totalLesson }} Lessons - {{ $totalCourse }} Comprehensive Courses</h2>
        </div>
        <div class="accordion" id="accordionPanelsStayOpenExample">
            @foreach ($courses as $course)
                <div class="accordion-item">
                    <h2 class="accordion-header" id="panelsStayOpen-headingOne">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#panelsStayOpen-collapseOne" aria-expanded="true"
                            aria-controls="panelsStayOpen-collapseOne">
                            <img src="{{ asset($course->icon) }}" class="course-icon"> {{ $course->title }}
                        </button>
                    </h2>
                    <div id="panelsStayOpen-collapseOne" class="accordion-collapse collapse show"
                        aria-labelledby="panelsStayOpen-headingOne">
                        <div class="accordion-body">
                            <div class="row">

                                <div class="col-lg-6 col-md-6">
                                    <div class="s-content">
                                      

                                        <ul>
                                            @foreach ($course->coursegoals as $coursegoal)
                                                <li><i class="fa-solid fa-check"></i>{{ $coursegoal->goal }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>

                                <div class="col-lg-6 col-md-6">
                                    <div class="s-content">
                                    
                                        <ul>
                                            @foreach ($course->coursefeatures as $coursefeature)
                                                <li><i class="fa-solid fa-check"></i>{{ $coursefeature->feature }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
            <!-- <div class="accordion-item">
                                                                                                                                            <h2 class="accordion-header" id="panelsStayOpen-headingTwo">
                                                                                                                                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#panelsStayOpen-collapseTwo" aria-expanded="false" aria-controls="panelsStayOpen-collapseTwo">
                                                                                                                                                <i class="fa-solid fa-comment"></i>
                                                                                                                                                Arabic Characters
                                                                                                                                              </button>
                                                                                                                                            </h2>
                                                                                                                                            <div id="panelsStayOpen-collapseTwo" class="accordion-collapse collapse" aria-labelledby="panelsStayOpen-headingTwo">
                                                                                                                                              <div class="accordion-body">
                                                                                                                                                <div class="row">
                                                                                                                                                  <div class="col-lg-6 col-md-6">
                                                                                                                                                    <div class="s-content">
                                                                                                                                                      <h1>What You'll Get</h1>
                                                                                                                                                      <ul>
                                                                                                                                                        <li><i class="fa-solid fa-check"></i>180 Video Lessons</li>
                                                                                                                                                        <li><i class="fa-solid fa-check"></i>Interactive Quiz Questions</li>
                                                                                                                                                        <li><i class="fa-solid fa-check"></i>Flashcards with Audio</li>
                                                                                                                                                        <li><i class="fa-solid fa-check"></i>Audio Review Files</li>
                                                                                                                                                        <li><i class="fa-solid fa-check"></i>Downloadable Lecture Notes</li>
                                                                                                                                                      </ul>
                                                                                                                                                    </div>
                                                                                                                                                  </div>
                                                                                                                                                  <div class="col-lg-6 col-md-6">
                                                                                                                                                    <div class="s-content">
                                                                                                                                                      <h1>What You'll Learn</h1>
                                                                                                                                                      <ul>
                                                                                                                                                        <li><i class="fa-solid fa-check"></i>Start from absolute newbie</li>
                                                                                                                                                        <li><i class="fa-solid fa-check"></i>Learn real conversational Chinese in months</li>
                                                                                                                                                        <li><i class="fa-solid fa-check"></i>Master Chinese pronunciation, pinyin, &amp; tones</li>
                                                                                                                                                        <li><i class="fa-solid fa-check"></i>Building-block approach to reinforce learning</li>
                                                                                                                                                        <li><i class="fa-solid fa-check"></i>Integrated real-world native speaker dialogues</li>
                                                                                                                                                      </ul>
                                                                                                                                                    </div>
                                                                                                                                                  </div>
                                                                                                                                                </div>
                                                                                                                                              </div>
                                                                                                                                            </div>
                                                                                                                                          </div>
                                                                                                                                          <div class="accordion-item">
                                                                                                                                            <h2 class="accordion-header" id="panelsStayOpen-headingThree">
                                                                                                                                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#panelsStayOpen-collapseThree" aria-expanded="false" aria-controls="panelsStayOpen-collapseThree">
                                                                                                                                                <i class="fa-solid fa-comment"></i>
                                                                                                                                                Intermediate Conversational
                                                                                                                                              </button>
                                                                                                                                            </h2>
                                                                                                                                            <div id="panelsStayOpen-collapseThree" class="accordion-collapse collapse" aria-labelledby="panelsStayOpen-headingThree">
                                                                                                                                              <div class="accordion-body">
                                                                                                                                                <div class="row">
                                                                                                                                                  <div class="col-lg-6 col-md-6">
                                                                                                                                                    <div class="s-content">
                                                                                                                                                      <h1>What You'll Get</h1>
                                                                                                                                                      <ul>
                                                                                                                                                        <li><i class="fa-solid fa-check"></i>180 Video Lessons</li>
                                                                                                                                                        <li><i class="fa-solid fa-check"></i>Interactive Quiz Questions</li>
                                                                                                                                                        <li><i class="fa-solid fa-check"></i>Flashcards with Audio</li>
                                                                                                                                                        <li><i class="fa-solid fa-check"></i>Audio Review Files</li>
                                                                                                                                                        <li><i class="fa-solid fa-check"></i>Downloadable Lecture Notes</li>
                                                                                                                                                      </ul>
                                                                                                                                                    </div>
                                                                                                                                                  </div>
                                                                                                                                                  <div class="col-lg-6 col-md-6">
                                                                                                                                                    <div class="s-content">
                                                                                                                                                      <h1>What You'll Learn</h1>
                                                                                                                                                      <ul>
                                                                                                                                                        <li><i class="fa-solid fa-check"></i>Start from absolute newbie</li>
                                                                                                                                                        <li><i class="fa-solid fa-check"></i>Learn real conversational Chinese in months</li>
                                                                                                                                                        <li><i class="fa-solid fa-check"></i>Master Chinese pronunciation, pinyin, &amp; tones</li>
                                                                                                                                                        <li><i class="fa-solid fa-check"></i>Building-block approach to reinforce learning</li>
                                                                                                                                                        <li><i class="fa-solid fa-check"></i>Integrated real-world native speaker dialogues</li>
                                                                                                                                                      </ul>
                                                                                                                                                    </div>
                                                                                                                                                  </div>
                                                                                                                                                </div>
                                                                                                                                              </div>
                                                                                                                                            </div>
                                                                                                                                          </div> -->
        </div>
    </div>

    <div class="questionpo">

        <div class="accordion" id="accordionExample">


            @foreach ($faqs as $faq)
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingOne">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            {{ $faq->question }}
                        </button>
                    </h2>
                    <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                        data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            <div class="body">
                                <p>{{ $faq->answer }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach

        </div>

    </div>
@endsection

@section('js')
    <script>
        var packageBoxes = document.querySelectorAll('.package-box');

        packageBoxes.forEach(function(packageBox) {
            packageBox.addEventListener('click', function() {
                var dataId = packageBox.getAttribute('data-id');

                const packageBoxBox = document.querySelectorAll("#" + dataId)[0];
                const moreSpan = document.querySelectorAll("#more-" + dataId)[0];
                const lessSpan = document.querySelectorAll("#less-" + dataId)[0];

                let isVisible = (packageBoxBox.style.display == 'block');

                isVisible = !isVisible;
                if (isVisible) {
                    packageBoxBox.style.display = 'block';
                    moreSpan.style.display = 'none';
                    lessSpan.style.display = 'block';
                } else {
                    packageBoxBox.style.display = 'none';
                    moreSpan.style.display = 'block';
                    lessSpan.style.display = 'none';
                }
            });
        });
    </script>
@endsection
