@inject('setting', 'App\Models\Setting')

<?php
$setting = $setting::first();
$course = App\Models\CourseStudent::where('user_id', auth()->user()->id)
    ->latest()
    ->first();
?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>@yield('title')</title>
    @include('Front.dashboard.layouts.head')
</head>

<body>
    <div class="main-wrapper">
        @include('Front.dashboard.layouts.header')
        <div class="overpaer">
            @include('Front.dashboard.layouts.sidebar')
            <div class="page-wrapper">
                <div id="chat-window">
                    <div class="page-content page-container position-relative" id="page-content">
                        <div class="">
                            <div class="row container-fluid d-flex justify-content-end m-0 p-0">
                                <div class="col-md-12 p-0">
                                    <div class="card card-bordered">
                                        <div class="card-header bg-primary">
                                            <h4 class="card-title text-white"><strong>Chat</strong></h4>
                                            <p class="text-end text-white closeButton" id="close-btn"><i
                                                    class="fa-solid fa-xmark"></i></p>
                                        </div>

                                        <div class="ps-container ps-theme-default ps-active-y chat-height"
                                            id="chat-content" style="overflow-y: scroll !important; height:67vh">
                                            <div class="bg-white shadow-sm p-4 sticky-sm-top">
                                                <p>We're here to help! Shoot us your question and we'll do our best to
                                                    respond in 1-2 business days. è°¢è°¢ (xiÃ¨ xie)! ðŸ˜Š</p>
                                            </div>
                                            <?php $messages = App\Models\Message::where('sender_id', auth()->user()->id)
                                                ->orWhere('reciver_id', auth()->user()->id)
                                                ->get(); ?>
                                            @foreach ($messages as $message)
                                                @if ($message->sender_type == get_class(auth()->user()))
                                                    <div class="media media-chat media-chat-reverse ">

                                                        <div class="media-body w-100 ">
                                                            <p>{{ $message->message_text }}</p>
                                                            <p class="meta" style="color:#9b9b9b;"><time
                                                                    datetime="2018">{{ $message->created_at->format('m-d H:I') }}</time>
                                                            </p>


                                                        </div>


                                                    </div>
                                                @else
                                                    <div class="media media-chat ">
                                                        <img class="avatar"
                                                            src="https://img.icons8.com/color/36/000000/administrator-male.png"
                                                            alt="...">

                                                        <div class="media-body">
                                                            <p>{{ $message->message_text }}</p>
                                                            <p class="meta"><time
                                                                    datetime="2018">{{ $message->created_at->format('m-d H:I') }}</time>
                                                            </p>
                                                        </div>

                                                    </div>
                                                @endif
                                            @endforeach
                                            <div class="media media-chat media-chat-reverse messages">
                                            </div>

                                            <div class="ps-scrollbar-x-rail" style="left: 0px; bottom: 0px;">
                                                <div class="ps-scrollbar-x" tabindex="0"
                                                    style="left: 0px; width: 0px;"></div>
                                            </div>
                                            <div class="ps-scrollbar-y-rail" style="top: 0px; height: 0px; right: 2px;">
                                                <div class="ps-scrollbar-y" tabindex="0"
                                                    style="top: 0px; height: 2px;"></div>
                                            </div>
                                        </div>

                                        <div class="publisher bt-1 border-light">

                                            @csrf
                                            <img class="avatar avatar-xs"
                                                src="https://img.icons8.com/color/36/000000/administrator-male.png"
                                                alt="...">
                                            <input class="publisher-input  message" type="text"
                                                placeholder="Write something">


                                            <button type="submit" class="publisher-btn text-info send  save-message"
                                                href="#" data-abc="true"><i
                                                    class="fa fa-paper-plane"></i></button>

                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="content container-fluid">
                    <div class="map-style">
                        <div class="usr-mg-info">
                            <h3>
                                @if ($course)
                                    <a href="{{ route('front.dashboard.index', $course?->course_id) }}">Dashoard</a>
                                @endif
                                @if (View::hasSection('level-2'))
                                    <strong>
                                        <i class="fa-solid fa-chevron-right"></i>
                                        @yield('level-2')
                                    </strong>
                                @endif
                                @if (View::hasSection('level-3'))
                                    <strong>
                                        <i class="fa-solid fa-chevron-right"></i>
                                        @yield('level-3')
                                    </strong>
                                @endif
                                @if (View::hasSection('level-4'))
                                    <strong>
                                        <i class="fa-solid fa-chevron-right"></i>
                                        @yield('level-4')
                                    </strong>
                                @endif
                                @if (View::hasSection('level-5'))
                                    <strong>
                                        <i class="fa-solid fa-chevron-right"></i>
                                        @yield('level-5')
                                    </strong>
                                @endif
                            </h3>
                        </div>
                    </div>
                </div>
                @yield('content')
            </div><!-- content container-fluid -->
        </div><!-- page-wrapper -->

    </div><!-- overpaer -->
    </div><!-- main-wrapper -->

    @include('Front.dashboard.layouts.footer')
    @include('Front.dashboard.layouts.footerjs')

</body>


</html>
