@extends('Front.layouts.master')

@section('title')
    New Password
@endsection
@section('css')
@endsection
@section('content')
    <div class="loginsection">
        <div class="container">
            <div class="row">
                <div class="container">
                    @if (Session::has('error'))
                        <div class="alert alert-danger">
                            {{ Session::get('error') }}
                        </div>
                    @endif
                    @if (Session::has('success'))
                        <div class="alert alert-success">
                            {{ Session::get('success') }}
                        </div>
                    @endif
                    <form action="{{ url('resetPassword') }}" method="post">
                        @csrf

                        <div class="form-group">
                            <input name= "token" type="text"
                                class="form-control form-control-user @error('token') is-invalid fparsley-error parsley-error @enderror"
                                id="exampleInputPassword" aria-describedby="textHelp" placeholder="Enter your Code...">
                        </div>
                        @error('token')
                            <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
                                <p>{{ $message }}</p>
                            </span>
                        @enderror
                        <div class="form-group">
                            <input name="password" type="password"
                                class="form-control form-control-user @error('password') is-invalid fparsley-error parsley-error @enderror"
                                id="exampleInputPassword" aria-describedby="textHelp"
                                placeholder="Enter your new password...">
                        </div>
                        @error('password')
                            <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
                                <p>{{ $message }}</p>
                            </span>
                        @enderror
                        <div class="form-group">
                            <input name="password_confirmation" type="password"
                                class="form-control form-control-user @error('password') is-invalid fparsley-error parsley-error @enderror"
                                id="exampleInputPassword_confirmation" aria-describedby="textHelp"
                                placeholder="Re-Enter your new password...">
                        </div>
                        @error('password')
                            <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
                                <p>{{ $message }}</p>
                            </span>
                        @enderror
                        <button class="btn btn-warning" type="submit"> submit</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection


@section('js')
@endsection
