@extends('Front.layouts.master')

@section('title', config('app.name') . ' - ForgetPassword')

@section('css')
@endsection
@section('content')
    <div class="loginsection">
        <div class="container">
            <div class="row">
                <div class="large-12">
                    @if (\Session::has('success'))
                        <div class="alert alert-success">
                            <ul>
                                <li>{!! \Session::get('success') !!}</li>
                            </ul>
                        </div>
                    @endif
                    <div class="logoooop"><a href="#"><img src="{{ asset('assets/img/logo.png') }}" height="100"></a>
                    </div>
                    <h3>Reset your password</h3>
                    <p>Enter the email address you that used to sign up, and we'll send you a password reset link</p>
                    <form action="{{ route('getemail') }}" method="post">
                        @csrf

                        <div class="input-text-forgetpassword">
                            <input class="@error('email') is-invalid fparsley-error parsley-error @enderror" type="text" name="email" value="{{old('email')}}" placeholder="email">
                            @error('email')
                              <span class="invalid-feedback text-red font-weight-bold text-capitalize mt-2" role="alert">
                                <p>{{ $message }}</p>
                              </span>
                              @enderror
                          </div>

                        <div class="button">
                            <button type="submit" class="signin-button btn  oneoff">Send</button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
@endsection


@section('js')
@endsection
