<div class="card-body">
    <div class="form-group mb-8">

        <div class="form-group" hidden>
            <label>Number
                <span class="text-danger">*</span></label>
            <input type="number" class="form-control @error('number') is-invalid fparsley-error parsley-error @enderror"
                placeholder="number" name="number" value="{{ old('number', $unit->number ?? '') }}" />
            @error('number')
                <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
                    <p>{{ $message }}</p>
                </span>
            @enderror
        </div>
        <div class="form-group">
            <label>Title
                <span class="text-danger">*</span></label>
            <input type="text" class="form-control @error('title') is-invalid fparsley-error parsley-error @enderror"
                placeholder="title" name="title" value="{{ old('title', $unit->title ?? '') }}" />
            @error('title')
                <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
                    <p>{{ $message }}</p>
                </span>
            @enderror
        </div>
        <div class="form-group">
            <label for="exampleSelect1">Course
                <span class="text-danger">*</span></label>
            <select class="form-control  @error('course_id') is-invalid fparsley-error parsley-error @enderror"
                id="exampleSelect1" name="course_id">
                <option value="">Choose Course</option>
                @foreach ($courses as $course)
                    <option value="{{ $course->id }}" {{ old('course_id') == $course->id ? 'selected' : '' }}>
                        {{ $course->title }} </option>
                @endforeach
            </select>
            @error('level_id')
                <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
                    <p>{{ $message }}</p>
                </span>
            @enderror
        </div>
        <div class="form-group col-5">
            <label>icon
                <span class="text-danger">*</span></label>
            <input type="file" class="form-control @error('icon') is-invalid fparsley-error parsley-error @enderror"
                placeholder="icon" name="icon" value="{{ old('icon', $course->icon ?? '') }} " />
            @error('icon')
                <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
                    <p>{{ $message }}</p>
                </span>
            @enderror
        </div>







    </div>
</div>
