@extends('Admin.layouts.master')

@section('title')
    Edit Placement Test Question
@endsection

@section('level-2')
<a href="{{route('admin.testQuestion.index')}}">Questions</a>
@endsection
@section('level-3')
    Edit
@endsection

@section('page_title', 'Edit Placement Test Question')

@section('css')


@endsection

@section('content')
    <!--begin::Container-->
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!--begin::Card-->
                <div class="card card-custom gutter-b example example-compact">
                    <div class="card-header">
                        <h3 class="card-title">Edit </h3>
                        <div class="card-toolbar">
                            <div class="example-tools justify-content-center">

                            </div>
                        </div>
                    </div>
                    <!--begin::Form-->
                    <form method="post" action="{{ route('admin.testQuestion.update') }}" enctype="multipart/form-data">
                        @csrf
                        @method ('put')

                        <div class="card-body">
                            <div class="form-group mb-8">

                                <h4 class="text-center p-5"> Question </h4>
                                <div class="row">
                                    <div class="form-group col-3">
                                        <label>images
                                            <span class="text-danger">*</span></label>
                                        <input type="file"
                                            class="form-control @error('images') is-invalid fparsley-error parsley-error @enderror"
                                            placeholder="image" name="images[]" multiple value="{{ old('images') }} " />
                                        @error('images')
                                            <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                                role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="form-group col-3">
                                        <label>audio
                                            <span class="text-danger">*</span></label>
                                        <input type="file"
                                            class="form-control @error('audio') is-invalid fparsley-error parsley-error @enderror"
                                            placeholder="image" name="audio" multiple value="{{ old('audio') }} " />
                                        @error('audio')
                                            <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                                role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="form-group col-6">
                                        <label for="exampleSelect1">Question Type <span class="text-danger">*</span></label>
                                        <select class="form-control" id="exampleSelect1" name="type">
                                            <option value="">choose Type</option>
                                            <option value="complete"
                                                {{ old('type') == 'complete' || (isset($testQuestion->type) && $testQuestion->type == 'complete') ? 'selected' : '' }}>
                                                complete</option>
                                            <option value="choose">choose</option>
                                            <option value="matchingpairs">matchingpairs</option>


                                        </select>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>question
                                        <span class="text-danger">*</span></label>
                                    <textarea type="text" class="form-control @error('question') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="question" name="question">
														{{ old('question', $testQuestion->question ?? '') }}
														</textarea>
                                    @error('question')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <input type="hidden" name="id" value="{{ $testQuestion->id }}">
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary mr-2">Submit</button>

                        </div>
                    </form>
                    <!--end::Form-->
                </div>


                <!--end::Card-->
            </div>
        </div>
    </div>
    <!--end::Container-->

@endsection


@section('js')
    <script src="{{ asset('assets/Admin/assets/custom/shared.js') }}"></script>

@endsection
