@extends('Admin.layouts.master')

@section('title')
    Edit Reviews
@endsection
@section('level-2')
    <a href="{{route('admin.review.index')}}">Reviews</a>
@endsection
@section('level-3')
Edit
@endsection
@section('page_title', 'Edit Reviews')

@section('css')


@endsection

@section('content')




    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!--begin::Card-->
                <div class="card card-custom gutter-b example example-compact">
                    <div class="card-header">
                        <h3 class="card-title">Edit Reviews</h3>
                        <div class="card-toolbar">
                            <div class="example-tools justify-content-center">

                            </div>
                        </div>
                    </div>
                    <!--begin::Form-->
                    <form method="post" action="{{ route('admin.review.update') }}" enctype="multipart/form-data">
                        @csrf
                        @method ('put')
                        <div class="card-body">
                            <div class="form-group mb-8">
                                <input type="hidden" name="id" value="{{ $review->id }}">
                                <div class="form-group">

                                    <label>Name
                                        <span class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('name') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="Name" name="name" value="{{ old('name', $review->name) }}" />
                                    @error('name')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">

                                    <label>Rate
                                        <span class="text-danger">*</span>
                                    </label>
                                    <input type="text"
                                        class="form-control @error('rate') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="Rate" name="rate" value="{{ old('rate', $review->rate) }}" />
                                    @error('rate')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="exampleTextarea">Comment</label>
                                    <textarea class="form-control @error('comment') is-invalid fparsley-error parsley-error @enderror" placeholder="Comment"
                                        name="comment">{{ old('comment', $review->comment) }}</textarea>
                                    @error('comment')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-5">
                                    <label>Image
                                        <span class="text-danger">*</span></label>
                                    <input type="file"
                                        class="form-control @error('image') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="image" name="image"
                                        value="{{ old('image', $review->image ?? '') }} " />
                                    @error('image')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary mr-2">Submit</button>

                            </div>
                        </div>
                    </form><!--end::Form-->
                </div>


                <!--end::Card-->
            </div>
        </div>
    </div><!--end::Container-->

@endsection


@section('js')


@endsection
