@extends('Admin.layouts.master')

@section('title')
    Create quiz Question
@endsection

@section('level-2')
    <a href="{{route('admin.lesson.index')}}">lessons</a>
@endsection
@section('level-3')
    <a href="{{route('admin.quizquestion.index', $id)}}">Quiz</a>
@endsection
@section('level-4')
    Create
@endsection

@section('page_title', 'Create quiz Question')

@section('css')
@endsection

@section('content')
    <!--begin::Container-->
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!--begin::Card-->
                <div class="card card-custom gutter-b example example-compact">
                    <div class="card-header">
                        <h3 class="card-title">Create quiz Question</h3>
                        <div class="card-toolbar">
                            <div class="example-tools justify-content-center">

                            </div>
                        </div>
                    </div>
                    <!--begin::Form-->
                    <form method="post" action="{{ route('admin.quizquestion.store') }}" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="quiz_id" value="{{ $id }}">

                        <div class="card-body">
                            <div class="form-group mb-8">

                                <h4 class="text-center p-5"> Question </h4>
                                <div class="row">
                                    <div class="form-group col-3">
                                        <label>images
                                            <span class="text-danger">*</span></label>
                                        <input type="file"
                                            class="form-control @error('images') is-invalid fparsley-error parsley-error @enderror"
                                            placeholder="image" name="images[]" multiple value="{{ old('images') }} " />
                                        @error('images')
                                            <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                                role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="form-group col-3">
                                        <label>audio
                                            <span class="text-danger">*</span></label>
                                        <input type="file"
                                            class="form-control @error('audio') is-invalid fparsley-error parsley-error @enderror"
                                            placeholder="image" name="audio" multiple value="{{ old('audio') }} " />
                                        @error('audio')
                                            <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                                role="alert">
                                                <p>{{ $message }}</p>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="form-group col-6">
                                        <label for="exampleSelect1">Question Type <span class="text-danger">*</span></label>
                                        <select class="form-control" id="exampleSelect1" name="type">
                                            <option value="" disabled>choose Type</option>
                                            <option value="complete" {{ old('type') == 'complete' ? 'selected' : '' }}>
                                                complete</option>
                                            <option value="choose"{{ old('type') == 'choose' ? 'selected' : '' }}>choose
                                            </option>
                                            <option
                                                value="matchingpairs"{{ old('type') == 'matchingpairs' ? 'selected' : '' }}>
                                                matchingpairs</option>
                                            <option
                                                value="conversation"{{ old('type') == 'conversation' ? 'selected' : '' }}>
                                                conversation</option>



                                        </select>
                                    </div>
                                </div>


                                <div class="form-group">
                                    <label>title
                                        <span class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('title') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="title" name="title" value="{{ old('title') }}" />


                                    @error('title')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">

                                    <label>question
                                        <span class="text-danger">*</span>
                                        <span class="text-danger"> In Complete Type split words by 5dots (.....)</span>
                                        <span class="text-danger">*</span>
                                        <span class="text-danger"> In Matching Pair Type split words by coma (,)</span>
                                    </label>
                                    <textarea type="text" class="form-control @error('question') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="question" name="question">{{ old('question') }}</textarea>
                                    @error('question')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>


                                <h4 class="text-center mb-5 mt-5"> Answers </h4>
                                <div id="exampleDate">
                                    <div class="row" id="formRow0">
                                        <div class="col-md-12 col-sm-4 col-lg-12 mb-3 m-form__group">

                                            <label>answer
                                                <span class="text-danger">*</span>

                                                <span class="text-danger"> In Matching Pair or conversation Type add status
                                                    of answer according to question and mark all correct</span></label>
                                            <textarea type="text" class="form-control @error('answer') is-invalid fparsley-error parsley-error @enderror"
                                                placeholder="answer" name="answer[0][ans]"></textarea>
                                            @error('answer')
                                                <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                                    role="alert">
                                                    <p>{{ $message }}</p>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="col-md-12 col-sm-2 col-lg-3 mb-3 m-form__group"
                                            style=" padding-top: 33px;">
                                            <label> image </label>
                                            <input type="file" class="p-2" name="answer[0][image]">
                                        </div>

                                        <div class="col-md-12 col-sm-2 col-lg-3 mb-3 m-form__group"
                                            style=" padding-top: 33px;">
                                            <label> audio </label>
                                            <input type="file" class="p-2" name="answer[0][audio]">
                                        </div>

                                        <div class="col-md-12 col-sm-2 col-lg-2 mb-2 m-form__group"
                                            style=" padding-top: 69px;">

                                            <input type="checkbox" class="p-2" name="answer[0][correct]" value=1> Correct
                                            Answer
                                        </div>
                                        <div class="col-md-12 col-sm-2 col-lg-2 mb-2 m-form__group"
                                            style=" padding-top: 69px;">


                                            <input type="number"
                                                class="form-control @error('status') is-invalid fparsley-error parsley-error @enderror"
                                                name="answer[0][status]"> status

                                            @error('answer')
                                                <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                                    role="alert">
                                                    <p>{{ $message }}</p>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="col-md-12 col-sm-1 col-lg-2 mb-2 mt-2 p-4 m-form__group"
                                            style=" padding-top: 44px!important ;">


                                            <a class="btn btn-primary p-2" id="addButton" data-order="1"><i
                                                    class="fa fa-plus-square"></i></a>
                                        </div>


                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary mr-2">Submit</button>

                        </div>
                    </form>
                    <!--end::Form-->
                </div>


                <!--end::Card-->
            </div>
        </div>
    </div>
    <!--end::Container-->

@endsection


@section('js')
    <script>
        $(document).ready(function() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            })
            $('#addButton').click(function() {
                let i = $(this).data('order');
                $("#exampleDate").append(`<div id="exampleDate">\
                <div class="row" id="formRow${i}">\
                  <div class="col-md-12 col-sm-4 col-lg-12 mb-3 m-form__group">\

				  <label>answer\
														<span class="text-danger">*</span></label>\
														<textarea type="text" class="form-control @error('answer') is-invalid fparsley-error parsley-error @enderror" placeholder="answer"  name="answer[${i}][ans]" ></textarea>\
														@error('answer')\
                                                       <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">\
                                                          <p>{{ $message }}</p>\
                                                            </span>
                                                          @enderror
                  </div>\

                  \
				  <div class="col-md-12 col-sm-2 col-lg-3 mb-3 m-form__group" style=" padding-top: 33px;">\
				  image
              <input type="file" class="p-2" name="answer[${i}][image]" >  \
				  </div>\
				  <div class="col-md-12 col-sm-2 col-lg-3 mb-3 m-form__group" style=" padding-top: 33px;">\
				   audio
				  <input type="file" class="p-2" name="answer[${i}][audio]" >  \
					  </div>\

				  <div class="col-md-12 col-sm-2 col-lg-2 mb-3 m-form__group" style=" padding-top: 44px;">\

				  <input type="checkbox" class="p-2" name="answer[${i}][correct]">  Correct Answer\
					  </div>\
					  <div class="col-md-12 col-sm-2 col-lg-2 mb-2 m-form__group" style=" padding-top: 44px;">\


			  <input type="number" class="form-control @error('status') is-invalid fparsley-error parsley-error @enderror"   name="answer[${i}][status]" > status \


</div>\
                </div>\
              </div>`);

                $(this).data('order', $(this).data('order') + 1);
            });
        });
    </script>

@endsection
