<div class="form-group">
    <label>Name<span class="text-danger">*</span></label>
    <input type="text" class="form-control @error('name') is-invalid fparsley-error parsley-error @enderror"
        placeholder="Name" name="name" value="{{ old('name', $package->name ?? '') }}" />
    @error('name')
        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
            <p>{{ $message }}</p>
        </span>
    @enderror
</div>

<div class="form-group">
    <label for="exampleTextarea">Descrption<span class="text-danger">*</span></label>
    <textarea class="form-control @error('description') is-invalid fparsley-error parsley-error @enderror"
        placeholder="Description" name="description">{{ old('description', $package->description ?? '') }}</textarea>
    @error('description')
        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
            <p>{{ $message }}</p>
        </span>
    @enderror
</div>

<div class="form-group">
    <label>Price<span class="text-danger">*</span></label>
    <input type="text" class="form-control @error('price') is-invalid fparsley-error parsley-error @enderror"
        placeholder="Price" name="price" value="{{ old('price', $package->price ?? '') }}" />
    @error('price')
        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
            <p>{{ $message }}</p>
        </span>
    @enderror
</div>

<div class="form-group">
    <label>Courses<span class="text-danger">*</span></label>
    <select class="form-control form-select" name="courses[]" multiple aria-label="multiple select example">

        @php
            $package_courses = isset($package) ? $package?->courses->pluck('id')->toArray() : [];
        @endphp
        @foreach ($courses as $course)
            <option value="{{ $course->id }}" @if ((old('courses') || isset($package)) && in_array($course->id, old('courses', $package_courses ?? []))) selected @endif>Course :
                {{ $course->title }}
            </option>
        @endforeach
    </select>
    @error('courses')
        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
            <p>{{ $message }}</p>
        </span>
    @enderror
</div>
