@extends('Admin.layouts.master')

@section('title')
    Edit guide
@endsection
@section('level-2')
    <a href="{{route('admin.guide.index')}}">guide</a>
@endsection
@section('level-3')
Edit
@endsection
@section('title', 'Edit guide ')

@section('css')


@endsection

@section('content')
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!--begin::Card-->
                <div class="card card-custom gutter-b example example-compact">
                    <div class="card-header">
                        <h3 class="card-title">Edit guide </h3>
                        <div class="card-toolbar">
                            <div class="example-tools justify-content-center">

                            </div>
                        </div>
                    </div>
                    <!--begin::Form-->
                    <form method="post" action="{{ route('admin.guide.update') }}" enctype="multipart/form-data">
                        @csrf
                        @method ('put')
                        <div class="card-body">
                            <div class="form-group mb-8">
                                <input type="hidden" name="id" value="{{ $guide->id }}">
                                <div class="form-group">

                                    <label>Title
                                        <span class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('title') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="Title" name="title" value="{{ old('title', $guide->title) }}" />
                                    @error('title')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="exampleTextarea">description</label>
                                    <textarea type="text"class="form-control @error('description') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="description" name="description">
                 {{ $guide->description }} </textarea>
                                    @error('description')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="exampleSelect1">guidesubcategory
                                        <span class="text-danger">*</span></label>
                                    <select
                                        class="form-control  @error('guidecategory_id') is-invalid fparsley-error parsley-error @enderror"
                                        id="exampleSelect1" name="guide_sub_category_id">
                                        <option value="">choose guidesubcategory</option>
                                        @foreach ($guidesubcategories as $guidesubcategory)
                                            <option value="{{ $guidesubcategory->id }}"
                                                {{ old('guidesubcategory_id') == $guidesubcategory->id || $guidesubcategory->id == $guide->guide_sub_category_id ? 'selected' : '' }}>
                                                {{ $guidesubcategory->title }}</option>
                                        @endforeach
                                    </select>
                                    @error('guide_sub_category_id')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>


                                <div class="form-group">
                                    <label>created By
                                        <span class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('created_by') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="created_by" name="created_by"
                                        value="{{ old('created_by', $guide->created_by ?? ' ') }}" />
                                    @error('created_by')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label>Written at
                                        <span class="text-danger">*</span></label>
                                    <input type="date"
                                        class="form-control @error('written_at') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="written_at" name="written_at"
                                        value="{{ old('written_at', $guide->written_at ?? ' ') }}" />
                                    @error('written_at')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary mr-2">Submit</button>

                            </div>
                        </div>
                    </form><!--end::Form-->
                </div>


                <!--end::Card-->
            </div>
        </div>
    </div><!--end::Container-->

@endsection


@section('js')


@endsection
