@extends('Admin.layouts.master')

@section('title')
    Create Faq
@endsection
@section('level-2')
    <a href="{{route('admin.faq.index')}}">Faq</a>
@endsection
@section('level-3')
Create
@endsection
@section('page_title', 'Create Faq')

@section('css')


@endsection

@section('content')
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!--begin::Card-->
                <div class="card card-custom gutter-b example example-compact">
                    <div class="card-header">
                        <h3 class="card-title">Create Faq</h3>
                        <div class="card-toolbar">
                            <div class="example-tools justify-content-center">

                            </div>
                        </div>
                    </div>
                    <!--begin::Form-->
                    <form method="post" action="{{ route('admin.faq.store') }}">
                        @csrf
                        <div class="card-body">
                            <div class="form-group mb-8">
                                <div class="form-group">
                                    <label for="exampleSelect1">FaqCategories
                                        <span class="text-danger">*</span></label>
                                    <select
                                        class="form-control  @error('faq_category_id') is-invalid fparsley-error parsley-error @enderror"
                                        id="exampleSelect1" name="faq_category_id">
                                        <option value="">choose FaqCategories</option>
                                        @foreach ($faqcategories as $faqcategory)
                                            <option value="{{ $faqcategory->id }}"
                                                {{ old('faq_category_id') == $faqcategory->id ? 'selected' : '' }}>
                                                {{ $faqcategory->title }}</option>
                                        @endforeach
                                    </select>
                                    @error('faq_category_id')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label>Question
                                        <span class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('question') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="Question" name="question" value="{{ old('question') }}" />
                                    @error('question')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label>Answer
                                        <span class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('answer') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="Answer" name="answer" value="{{ old('answer') }}" />
                                    @error('answer')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>



                            </div>

                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary mr-2">Submit</button>

                            </div>
                        </div>
                    </form><!--end::Form-->
                </div>


                <!--end::Card-->
            </div>
        </div>
    </div>

@endsection


@section('js')


@endsection
