@extends('Admin.layouts.master')

@section('title')
    Question details
@endsection
@section('level-2')
    <a href="{{ route('admin.course.index') }}">Courses ({{ $quizQuestion->quiz->lesson->unit->level->course->title }})</a>
@section('level-3')
    <a href="{{ route('admin.course.level.index', $quizQuestion->quiz->lesson->unit->level->course_id) }}">Level
        ({{ $quizQuestion->quiz->lesson->unit->level->number }})</a>
@section('level-4')
    <a href="{{ route('admin.course.unit.index', $quizQuestion->quiz->lesson->unit->level_id) }}">Units
        ({{ $quizQuestion->quiz->lesson->unit->number }})</a>
@section('level-5')
    <a href="{{ route('admin.course.lesson.index', $quizQuestion->quiz->lesson->unit_id) }}">Lessons
        ({{ $quizQuestion->quiz->lesson->title }})</a>
@section('level-6')
    <a href="{{ route('admin.course.quizquestion.index', $quizQuestion->quiz_id) }}">Quiz Questions
        ({{ $quizQuestion->title }})</a>
@section('level-7')
    Edit
@endsection
@endsection
@endsection
@endsection
@endsection
@endsection

@section('page_title', 'Question details')

@section('css')


@endsection

@section('content')
<!--begin::Container-->
<div class="container">
<div class="row">
<div class="col-md-12">
<!--begin::Card-->
<div class="card card-custom gutter-b example example-compact">
<div class="card-header">
    <h3 class="card-title">
        Show quiz Question ({{ $quizQuestion->title }})
        <i class="fa fa-chevron-right mr-2 ml-2"></i>
        belongs to lesson ({{ $quizQuestion->quiz->lesson->title }})
    </h3>

    <div class="card-toolbar">

    </div>
</div>
<div class="container">
    <div class="col-xl-12">

    </div>
    <h4 class=" text-center p-5"> Question </h4>
    @if ($quizQuestion->title)
        <p class="font-weight-bold display-4 QUANS"><span class="font-weight-bold"> Question Title
                :</span> {{ $quizQuestion->title }} </p>
    @endif
    @if ($quizQuestion->question)
        <p class="font-weight-bold display-4 QUANS"><span class="font-weight-bold"> Question :</span>
            {{ $quizQuestion->question }} ? </p>
    @endif

    @if (!$quizQuestion->images->isEmpty()) <!--begin::List Widget 2-->
        <div class="card card-custom  card-stretch gutter-b">
            <!--begin::Header-->
            <div class="card-header border-0">
                <h3 class="card-title ">Images :</h3>
                <div class="card-toolbar">

                </div>
            </div>
            <!--end::Header-->
            <!--begin::Body-->
            <div class="card-body pt-2">
                <!--begin::Item-->
                @foreach ($quizQuestion->images as $image)
                    <div class="d-flex align-items-center mb-10">

                        <img style="width:200px;"src="{{ asset($image->image) }}"
                            class="h-50 align-self-end" alt="" />
                    </div>
                    <!--end::Item-->
                @endforeach

            </div>
            <!--end::Body-->
        </div>
        <!--end::List Widget 2-->
    @endif

    @isset($quizQuestion->audios->audio)
        <h4> Audio: </h4>
        <audio class="ml-3" controls>
            <source src="{{ asset($quizQuestion->audios->audio) }}" type="audio/mpeg">
        </audio>
        @endif
    </div>
    <h4 class=" text-center p-5"> Answers </h4>
    {{-- @if (auth()->guard('admin')->user()->hasPermission('quiz')) --}}
     <a class=" font-weight-bolder p-5"
            href="{{ route('admin.quizAnswer.create', $quizQuestion->id) }}"> Create</a>
            {{-- @endif --}}
    <div class="container">
        <table class="table">
            <thead>
                <tr>
                    <th scope="col">#</th>
                    <th scope="col">answer</th>
                    <th scope="col"> correct</th>
                    <th scope="col">image</th>
                    <th scope="col">audio</th>
                    <th scope="col"> Action </th>
                </tr>
            </thead>
            <tbody>
                @foreach ($quizQuestion->answers as $key => $answer)
                    <tr>

                        <td>{{ ++$key }} </td>
                        <td>{{ $answer->answer }}</td>
                        <td>
                            @if ($answer->is_correct == 1)
                                Correct
                            @else
                                False
                            @endif
                        </td>
                        <td>
                            @isset($answer->images)
                            <img style="width:200px;"src="{{ asset($answer->images->image) }}" @endisset
                                </td>

                        <td>
                            @if ($answer->audios)
                                <a target="_blank" class="btn btn-outline-success btn-sm"
                                    href="{{ asset($answer->audios->audio) }}" role="button">
                                    <i class="fas fa-eye"></i>&nbsp; show
                                </a>
                            @endif
                        </td>
                        <td>
                            {{-- @if (auth()->guard('admin')->user()->hasPermission('quiz')) --}}
                                <a href="{{ route('admin.quizAnswer.edit', $answer->id) }}"
                                    class="btn btn-sm btn-clean btn-icon " title="Edit details">
                                    <span class="svg-icon svg-icon-md">
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                            xmlns:xlink="http://www.w3.org/1999/xlink" width="24px"
                                            height="24px" viewBox="0 0 24 24" version="1.1">
                                            <g stroke="none" stroke-width="1" fill="none"
                                                fill-rule="evenodd">
                                                <rect x="0" y="0" width="24" height="24" />
                                                <path
                                                    d="M8,17.9148182 L8,5.96685884 C8,5.56391781 8.16211443,5.17792052 8.44982609,4.89581508 L10.965708,2.42895648 C11.5426798,1.86322723 12.4640974,1.85620921 13.0496196,2.41308426 L15.5337377,4.77566479 C15.8314604,5.0588212 16,5.45170806 16,5.86258077 L16,17.9148182 C16,18.7432453 15.3284271,19.4148182 14.5,19.4148182 L9.5,19.4148182 C8.67157288,19.4148182 8,18.7432453 8,17.9148182 Z"
                                                    fill="#000000" fill-rule="nonzero"
                                                    transform="translate(12.000000, 10.707409) rotate(-135.000000) translate(-12.000000, -10.707409) " />
                                                <rect fill="#000000" opacity="0.3" x="5" y="20"
                                                    width="15" height="2" rx="1" />
                                            </g>
                                        </svg>
                                    </span>
                                </a>


                                <a class="btn btn-sm btn-clean btn-icon delete_form" title="Delete"
                                    href="{{ route('admin.quizAnswer.destroy', $answer->id) }}">
                                    <span class="svg-icon svg-icon-md">
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                            xmlns:xlink="http://www.w3.org/1999/xlink" width="24px"
                                            height="24px" viewBox="0 0 24 24" version="1.1">
                                            <g stroke="none" stroke-width="1" fill="none"
                                                fill-rule="evenodd">
                                                <rect x="0" y="0" width="24" height="24" />
                                                <path
                                                    d="M6,8 L6,20.5 C6,21.3284271 6.67157288,22 7.5,22 L16.5,22 C17.3284271,22 18,21.3284271 18,20.5 L18,8 L6,8 Z"
                                                    fill="#000000" fill-rule="nonzero" />
                                                <path
                                                    d="M14,4.5 L14,4 C14,3.44771525 13.5522847,3 13,3 L11,3 C10.4477153,3 10,3.44771525 10,4 L10,4.5 L5.5,4.5 C5.22385763,4.5 5,4.72385763 5,5 L5,5.5 C5,5.77614237 5.22385763,6 5.5,6 L18.5,6 C18.7761424,6 19,5.77614237 19,5.5 L19,5 C19,4.72385763 18.7761424,4.5 18.5,4.5 L14,4.5 Z"
                                                    fill="#000000" opacity="0.3" />
                                            </g>
                                        </svg>
                                    </span>
                                </a>
                            {{-- @endif --}}
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>


</div>


<!--end::Card-->
</div>
</div>
</div>
<!--end::Container-->

@endsection


@section('js')
<script src="{{ asset('asseets/admin/assets/js/pages/widgets.js') }}"></script>

@endsection
