@extends('Admin.layouts.master')

@section('title')
    Create Level
@endsection
@section('page_title', 'Create Level')

@section('css')
@endsection
@section('level-2')
    <a href="{{route('admin.course.index')}}">Course  ({{$course->title}})</a>
@endsection
@section('level-3')
    <a href="{{route('admin.course.level.index', $courseId)}}">Levels</a>
@endsection
@section('level-4')
    Create
@endsection

@section('content')
    <!--begin::Container-->
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!--begin::Card-->
                <div class="card card-custom gutter-b example example-compact">
                    <div class="card-header">
                        <h3 class="card-title">
                            Create Level
                            <i class="fa fa-chevron-right mr-2 ml-2"></i>
                            belongs to course ({{$course->title}})
                        </h3>
                        <div class="card-toolbar">
                            <div class="example-tools justify-content-center">

                            </div>
                        </div>
                    </div>
                    <!--begin::Form-->
                    <form method="post" action="{{ route('admin.course.level.store') }}" enctype="multipart/form-data">
                        @csrf
                        @include('Admin.course.level._form')
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary mr-2">Submit</button>

                        </div>
                    </form>
                    <!--end::Form-->
                </div>


                <!--end::Card-->
            </div>
        </div>
    </div>
    <!--end::Container-->

@endsection


@section('js')


@endsection
