@extends('Admin.layouts.master')

@section('title')
    Import country
@endsection
@section('level-2')
    <a href="{{route('admin.country.index')}}">Country</a>
@endsection
@section('level-3')
    Import
@endsection
@section('page_title', 'Create country')

@section('css')


@endsection

@section('content')
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!--begin::Card-->
                <div class="card card-custom gutter-b example example-compact">
                    <div class="card-header">
                        <h3 class="card-title">Import country</h3>
                        <div class="card-toolbar">
                            <div class="example-tools justify-content-center">

                            </div>
                        </div>
                    </div>

                    @if (count($errors) > 0)
                        <div class="row">
                            <div class="col-md-12">
                                <div class="alert alert-danger alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                    <h4><i class="icon fa fa-ban"></i> Error!</h4>
                                    @foreach($errors->all() as $error)
                                    {{ $error }} <br>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    @endif
                    @if (Session::has('success'))
                        <div class="row">
                            <div class="col-md-12">
                                <div class="alert alert-success alert-dismissible">
                                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                    <h5>{!! Session::get('success') !!}</h5>
                                </div>
                            </div>
                        </div>
                    @endif
                    <!--begin::Form-->
                    <form method="post" action="{{ route('admin.country.upimport') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="card-body">
                            <div class="form-group mb-8">
                                <div class="form-group">
                                    <label for="exampleTextarea">Upload File</label>
                                    <input type="file" class="form-control @error('file') is-invalid fparsley-error parsley-error @enderror" style="padding: 3px;" name="file" required />
                                    @error('file')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="card-footer">
                                <button type="submit" class="btn btn-success" name="upload">Upload</button>
                            </div>
                        </div>
                    </form><!--end::Form-->
                </div>
                <!--end::Card-->
            </div>
        </div>
    </div>

@endsection


@section('js')


@endsection
