<?php

namespace App\Service;

use App\Mail\UserOtpEmail;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;


class UserOtpService
{
    public function sendCode(): void
    {
        $otpCode = self::generateCode();
        auth()->user()->update(['otp_code' => $otpCode]);
        Mail::to(auth()->user()->email)->send(new UserOtpEmail($otpCode));
        return;
    }

    public static function generateCode()
    {
        return Str::random(3) . '-' . Str::random(3);
    }
}
