<?php

namespace App\Service\TapPaymentService;

use Exception;
use GuzzleHttp\Client;


trait TapTrait
{
    public function redirect(string $redirect): self
    {
        $this->redirect = $redirect;
        return $this;
    }

    public function amount(float $amount): self
    {
        $this->amount = $amount;
        return $this;
    }

    public function currency(?string $currency = null): self
    {
        $this->currency = $currency ? $currency : config('tap-payment.currency');
        return $this;
    }

    public function customerDetails(
        string $first_name,
        string $email,
        ?string $last_name = null,
        ?string $phone_code = null,
        ?string $phone_number = null,
    ): self {
        $this->customer = [
            'first_name' => $first_name,
            'last_name' => $last_name,
            'email' => $email,
            'phone' => [
                'country_code' => $phone_code,
                'number' => $phone_number,
            ]
        ];
        return $this;
    }

    private function url(?string $path = '', ?string $arg = ''): self
    {
        $this->url = config('tap-payment.url') . config('tap-payment.version') . $path .  $arg;
        return $this;
    }

    private function headers(): self
    {
        $this->headers['Authorization'] = config('tap-payment.api_key');
        $this->headers['accept'] = 'application/json';
        $this->headers['content-type'] = 'application/json';
        return $this;
    }

    private function createCharge(): string
    {
        try {
            $response = $this->client->request(
                $this->method,
                $this->url,
                [
                    'body' => json_encode($this->body()),
                    'headers' => $this->headers,
                ]
            );

            return $response->getBody();
        } catch (\Throwable $th) {
            throw new Exception('Something went wrong.');
        }
    }

    private function getChargeById()
    {
        try {
            $response = $this->client->request(
                $this->method,
                $this->url,
                [
                    'headers' => $this->headers,
                ]
            );

            return $response->getBody();
        } catch (\Throwable $th) {
            throw new Exception('Something went wrong.');
        }
    }

    private function body(): array
    {
        return [
            'amount' => $this->amount,
            'currency' => $this->currency,
            'customer_initiated' => true,
            'threeDSecure' => true,
            'save_card' => false,
            'customer' => $this->customer,
            'source' => [
                'id' => 'src_all'
            ],
            'redirect' => [
                'url' => $this->redirect
            ]
        ];
    }

    private function client(): self
    {
        if (!isset($this->client)) {
            $this->client = new Client();
        }
        return $this;
    }

    private function method(string $method = 'GET'): self
    {
        $this->method = $method;
        return $this;
    }
}
