<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TestQuestion extends Model
{
    use HasFactory;

    protected $fillable = [
        'question', 'status', 'type'
    ];


    public function answers()
    {
        return $this->hasMany(TestAnswer::class, 'question_id');
    }

    public function audios()
    {
        return $this->morphOne(Audio::class, 'audioable');
    }

    public function images()
    {
        return $this->morphMany(Image::class, 'imageable');
    }
}
