<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Subscribe extends Model
{
    use HasFactory;

    protected $fillable = [
        'package_id',
        'user_id',
        'paid_amount',
        'code',
        'ref_code',
        'status',
    ];

    public function package()
    {
        return $this->belongsTo(Package::class);
    }

    public function seller()
    {
        return $this->belongsTo(Seller::class, 'code', 'ref_code');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
