<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GuideCategory extends Model
{
    use HasFactory;
    protected $append=[
        'Guide'
    ];

    protected $fillable=[
        'title','description'
    ];

    public function guideSubCategories(){
        return $this->hasMany(GuideSubCategory::class,'guide_category_id')->withCount('guide');
    }

    public function getGuideAttribute()
    {
        return $this->guideSubCategories->sum(function ($guideSubCategorey) {
            return $guideSubCategorey->guide_count;
        });
    }
}
