<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Guide extends Model
{
    use HasFactory;
    
    protected $fillable=[
        'title',
        'guide_sub_category_id',
        'written_at',
        'created_by',
        'description'
    
        ];


        public function guideSubCategory(){
         return $this->belongsTo(GuideSubCategory::class,'guide_sub_category_id');
        }

        public function guideDetails(){
            return $this->hasMany(GuideDetail::class,'guide_id');
        }


        
}
