<?php

namespace App\Http\Requests\Admin\Review;

use Illuminate\Foundation\Http\FormRequest;

class UpdateReviewRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'rate'     =>'required',
            'comment'  =>'required',
            'name'     =>'required',
            'image'    =>'image|mimes:jpeg,png,jpg,gif,svg|max:2048'

        ];
    }
}
