<?php

namespace App\Http\Requests\Admin\Courses;

use Illuminate\Foundation\Http\FormRequest;

class UpdateCourseRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'id'                => 'required|exists:courses,id',
            'title'             =>  'required',
            'code'              =>  'required|unique:courses,code,'.$this->id,
            // 'price'             =>  'required',
            // 'discount'          =>  'required',
            'icon'              =>   'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'background_color'  =>  'required',
            // 'type'              =>   'required'
        ];
    }
}
