<?php

namespace App\Http\Requests\Admin\Courses;

use Illuminate\Foundation\Http\FormRequest;

class CreateCourseRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title'             =>  'required',
            'code'              =>  'required|unique:courses,code',
            // 'price'             =>  'required',
            // 'discount'          =>  'required',
            'icon'              =>  'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'background_color'  =>  'required',
            // 'type'              =>   'required'
        ];
    }
}
