<?php

namespace App\Http\Repositories\Front;

use App\Models\User;
use Illuminate\Support\Facades\Hash;

use Laravel\Socialite\Facades\Socialite;
use App\Http\Interfaces\Front\SocialAuthInterface;
use Exception;
use Illuminate\Support\Facades\Auth;
use RealRashid\SweetAlert\Facades\Alert;

class SocialAuthRepository implements SocialAuthInterface
{


    protected $userModel;

    public function __construct(User $usermodel)
    {
        $this->userModel = $usermodel;
    }

    public function googleRedirect()
    {
        if (auth()->check()) {
            auth()->logout();
        }
        return Socialite::driver('google')->redirect();
    }

    public function googleCallback()
    {
        if (auth()->check()) {
            auth()->logout();
        }

        $socialuser = Socialite::driver('google')->user();
        $user = User::where('google_id', $socialuser->id)->first();


        try {

            if ($user) {
                auth()->login($user);
                return redirect()->route('front.dashboard.index', 0);

            } else {

                $user = User::create([
                    'name' => $socialuser->name,
                    'email' => $socialuser->email,
                    'google_id' => $socialuser->id,
                    'image' => $socialuser->avatar,
                    'password' => Hash::make(rand()),
                    'email_verified_at' => now(),
                ]);

                auth()->login($user);
            }
            return redirect()->route('auth.levelQuiz');
        } catch (Exception $e) {

            Alert::success('success', $e->getMessage());
            return redirect()->route('login');
        }
    }

    public function facebookRedirect()
    {
        if (auth()->check()) {
            auth()->logout();
        }
        return Socialite::driver('facebook')->redirect();
    }

    public function facebookCallback()
    {

        if (auth()->check()) {
            auth()->logout();
        }

        $socialuser = Socialite::driver('facebook')->user();
        $user = User::where('facebook_id', $socialuser->id)->first();


        try {

            if ($user) {
                auth()->login($user);
                return redirect()->route('front.dashboard.index', 0);

            } else {

                $user = User::create([
                    'name' => $socialuser->name,
                    'email' => $socialuser->email,
                    'facebook_id' => $socialuser->id,
                    'image' => $socialuser->avatar,
                    'password' => Hash::make(rand()),
                    'email_verified_at' => now(),
                ]);

                auth()->login($user);
            }
            return redirect()->route('auth.levelQuiz');
        } catch (Exception $e) {

            Alert::success('success', $e->getMessage());
            return redirect()->route('login');
        }
    }
}
