<?php 


namespace App\Http\Repositories\Front;

use App\Models\User;
use App\Models\Setting;
use Illuminate\Auth\Events\Verified;
use Illuminate\Support\Facades\Auth;
use Illuminate\Auth\Access\AuthorizationException;
use App\Http\Interfaces\Front\EmailVerificationInterface;


class EmailVerificationRepository implements EmailVerificationInterface{
    
    
    public function sendVerificationEmail()
    {

        if (auth()->user()->hasVerifiedEmail()) {
           
        session()->flash('error',' email already verified !');
        
        return redirect()->back();
        }

        auth()->user()->sendEmailVerificationNotification();

        session()->flash('success','verification link sent successfully !');
        
            return redirect()->back();
    }

    public function verify($request)
    {
        
        $user = User::find($request->route('id'));
 
         Auth::login($user);
     

        if ($request->route('id') != $request->user()->getKey()) {
            throw new AuthorizationException;
        }

        if ($request->user()->hasVerifiedEmail()) {

        $message='already verified';

        
        }

        if ($request->user()->markEmailAsVerified()) {
            event(new Verified($request->user()));
            $message = 'verified successfully ';
        }
        
         
        return  view(' mail.emailverifysuccess',compact('message'));
        
        
    }
}