<?php

namespace App\Http\Repositories\Front;

use Carbon\Carbon;
use App\Models\Faq;
use App\Models\Blog;
use App\Models\Unit;
use App\Models\User;
use App\Models\Admin;
use App\Models\Guide;
use App\Models\Level;
use App\Models\Course;
use App\Models\Lesson;
use App\Models\Message;
use App\Models\Package;
use App\Models\Setting;
use App\Models\FlashCard;
use App\Models\LessonFaq;
use App\Models\CourseGoal;
use App\Models\LessonReview;
use App\Models\CourseFeature;
use App\Models\CourseStudent;
use App\Models\GuideCategory;
use App\Models\LessonStudent;
use App\Models\GuideSubCategory;
use Illuminate\Support\Facades\DB;
use App\Models\UserMasterFlashCard;
use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\Model;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Front\DashboardInterface;

class DashboardRepository implements DashboardInterface
{
    protected $courseModel;
    protected $levelModel;
    protected $unitModel;
    protected $lessonModel;
    protected $flashCardModel;
    protected $lessonFaqModel;
    protected $lessonReviewModel;
    protected $coursegoalModel;
    protected $coursefeatureModel;
    protected $courseStudentModel;
    protected $lessonStudentModel;
    protected $faqModel;
    protected $blogModel;
    protected $guideCategoryModel;
    protected $guideModel;
    protected $packageModel;
    protected $messageModel;
    protected $settingModel;

    public function __construct(
        Course $course,
        Level $level,
        Unit $unit,
        Lesson $lesson,
        FlashCard $flashcard,
        LessonFaq $lessonFaq,
        LessonReview $lessonReview,
        CourseGoal $coursegoal,
        CourseFeature $coursefeature,
        CourseStudent $courseStudent,
        LessonStudent $lessonStudent,
        Faq $faq,
        Package $package,
        Blog $blog,
        GuideCategory $guideCategory,
        Guide $guide,
        Message $message,
        Setting $setting
    ) {
        $this->courseModel = $course;
        $this->levelModel = $level;
        $this->unitModel = $unit;
        $this->lessonModel = $lesson;
        $this->flashCardModel = $flashcard;
        $this->lessonFaqModel = $lessonFaq;
        $this->lessonReviewModel = $lessonReview;
        $this->coursegoalModel = $coursegoal;
        $this->coursefeatureModel = $coursefeature;
        $this->courseStudentModel = $courseStudent;
        $this->packageModel = $package;
        $this->lessonStudentModel = $lessonStudent;
        $this->faqModel = $faq;
        $this->blogModel = $blog;
        $this->guideCategoryModel = $guideCategory;
        $this->guideModel = $guide;
        $this->messageModel = $message;
        $this->settingModel = $setting;
    }
    public function index($id)
    {
        $user = auth()->user();
        $courses = $this->courseModel::get();
        $course = $this->courseModel::with('units')->find($id);

        $studentCourse = $this->courseStudentModel
            ::where('user_id', $user->id)
            ->where('course_id', $id)
            ->latest()
            ->first();

        return view('Front.dashboard.index', compact('course', 'courses', 'studentCourse'));
    }

    public function unitLesson($id)
    {
        $unit = $this->unitModel
            ::where('id', $id)
            ->with('lessons')
            ->first();

        return view('Front.dashboard.pages.unit-lesson', compact('unit'));
    }
    public function blog()
    {
        $blogs = $this->blogModel::get();
        return view('Front.dashboard.pages.blog', compact('blogs'));
    }
    public function singleBlog($id)
    {
        $blog = $this->blogModel::find($id);
        return view('Front.dashboard.pages.blog-siglepage', compact('blog'));
    }
    public function dashboardSign()
    {
        return view('Front.dashboard.pages.Dashboardnew-signup-user');
    }

    public function dashboardPlacement()
    {
        return view('Front.dashboard.pages.Dashboardafter-Placement');
    }

    public function lessonFlash($id)
    {

       

        $lesson = $this->lessonModel
            ::where('id', $id)
            ->with('flashCards', 'unit', 'lessonFaqs', 'lessonReviews')
            ->firstOrFail();
          
        if (!CourseStudent::where([
            'user_id' => auth()->id(),
            'unit_id' => $lesson->unit_id,
        ])->exists()) {


            return redirect()->back()->with('message', 'Please purchase this level to access this lesson.');
        }
        $ratingPercentages = [];
        for ($rating = 1; $rating <= 5; $rating++) {
            $ratingPercentages[$rating] = LessonReview::calculateRatingPercentage($lesson->id, $rating);
        }

        return view('Front.dashboard.pages.lesson-flashcards', compact('lesson', 'ratingPercentages'));
    }
    public function lessonPractice($id)
    {
        $flashcards = $this->flashCardModel::where('lesson_id', $id)->get();
        return view('Front.dashboard.pages.lesson-practice', compact('flashcards'));
    }

    public function lessonFaq($request)
    {
        $lessonfaq = $this->lessonFaqModel::create([
            'question' => $request->question,
            'lesson_id' => $request->lesson_id,
            'user_id' => Auth::user()->id,
        ]);

        return back()->with('message', 'Question send Successfully');
    }

    public function lessonReview($request)
    {
        $lessonReview = $this->lessonReviewModel
            ::where('lesson_id', $request->lesson_id)
            ->where('user_id', Auth::user()->id)
            ->first();

        if (!is_null($lessonReview)) {
            $lessonReview->update([
                'comment' => $request->comment,
            ]);
        } else {
            $lessonReview = $this->lessonReviewModel::create([
                'comment' => $request->comment,
                'lesson_id' => $request->lesson_id,
                'rate' => $request->rating??1,
                'user_id' => Auth::user()->id,
            ]);
        }

        return back();
    }

    public function lessonRate($rate, $lesson_id)
    {
        $review = $this->lessonReviewModel
            ::where('lesson_id', $lesson_id)
            ->where('user_id', Auth::user()->id)
            ->first();
        if ($review) {
            $review->update([
                'rate' => $rate,
            ]);
        } else {
            $review = $this->lessonReviewModel::create([
                'rate' => $rate,
                'lesson_id' => $lesson_id,
                'user_id' => Auth::user()->id,
            ]);
        }
        return redirect()->back();
    }

    public function price()
    {
        $courses = $this->courseModel::with('courseFeatures', 'courseGoals')->get();
        $totalCourse = Course::get()->count();
        $totalLesson = Lesson::get()->count();
        $packages = $this->packageModel->with(['courses.units'])->get();
        $faqs = $this->faqModel::get();
        return view('Front.dashboard.pages.price', compact('courses', 'faqs', 'packages','totalLesson','totalCourse'));
    }

    public function startCourseBeginner()
    {
        // $course = $this->courseModel::with('level')->first();

        // DB::transaction(function () use ($course) {
        //     $this->courseStudentModel::create([
        //         'user_id' => Auth::user()->id,
        //         'course_id' => $course->id,
        //         'level_id' => $course->level->first()->id,
        //         'enroll_date' => date('Y-m-d H:i:s'),
        //     ]);

        //     $this->lessonStudentModel::create([
        //         'user_id' => Auth::user()->id,
        //         'lesson_id' => $course->level->unit->lesson->id,
        //         'unit_id' => $course->level->unit->id,
        //         'level_id' => $course->level->id,
        //         'start_date' => date('Y-m-d H:i:s'),
        //     ]);
        // });

        return redirect()->route('front.dashboard.index', 0);
        // return redirect()->route('front.dashboard.index', $course->id);
    }

    public function startCourseTestResult($id)
    {
        $course = $this->courseModel
            ::where('id', $id)
            ->with('level')
            ->first();
        DB::transaction(function () use ($id, $course) {
            $this->courseStudentModel::create([
                'user_id' => Auth::user()->id,
                'course_id' => $id,
                'level_id' => $course->level->first()->id,
                'enroll_date' => date('Y-m-d H:i:s'),
            ]);

            $this->lessonStudentModel::create([
                'user_id' => Auth::user()->id,
                'lesson_id' => $course->level->unit->lesson->id,
                'unit_id' => $course->level->unit->id,
                'level_id' => $course->level->id,
                'start_date' => date('Y-m-d H:i:s'),
            ]);
        });
        return redirect()->route('front.dashboard.index', $course->id);
    }

    public function guides()
    {
        $categories = $this->guideCategoryModel::get();
        $setting = $this->settingModel::first();
        return view('Front.dashboard.pages.guides', compact('categories', 'setting'));
    }

    public function guidesDetails($id)
    {
        $guidecategory = $this->guideCategoryModel::with('guidesubCategories')->find($id);
        $setting = $this->settingModel::first();
        return view('Front.dashboard.guides.details', compact('guidecategory', 'setting'));
    }

    public function guidesSetting()
    {
        $setting = $this->settingModel::first();
        return view('Front.dashboard.guides.setting', 'setting');
    }

    public function guidesAccount($id)
    {
        $guide = $this->guideModel
            ::with('guideDetails')
            ->where('guide_sub_category_id', $id)
            ->first();
        $setting = $this->settingModel::first();
        return view('Front.dashboard.guides.account', compact('guide', 'setting'));
    }

    public function contact()
    {
        return view('Front.dashboard.pages.chat');
    }

    public function messages($request)
    {
        $user = User::find(auth()->user()->id);
        $admin = Admin::first();
        $messages = $this->messageModel::Where('reciver_id', $user->id)->get();
        foreach ($messages as $message) {
            $message->update([
                'read_at' => date('Y-m-d H:i:s'),
            ]);
        }
        $message = $user->sendMessage()->create([
            'message_text' => $request->message,
            'reciver_id' => $admin->id,
            'reciver_type' => get_class($admin),
        ]);

        return response()->json([
            'bool' => true,
            'message' => $request->message,
            'time' => $message->created_at->format('H:i'),
        ]);
    }

    public function notifications()
    {
        $user = auth()->user();
        $notifications = $user->unreadnotifications;
        return view('Front.dashboard.pages.notification', compact('notifications'));
    }

    public function markRead($id)
    {
        $notification = auth()
            ->user()
            ->notifications->where('id', $id)
            ->first();
        if ($notification) {
            $notification->markAsRead();
            return redirect()->back();
        }
    }

    public function markAllRead()
    {
        $usernotifications = auth()->user()->unreadnotifications;

        if ($usernotifications) {
            foreach ($usernotifications as $notification) {
                $notification->markAsRead();
            }

            return redirect()->back();
        }
    }

    public function next($id)
    {
        // $lesson = $this->lessonModel
        //     ::where('id', '>', $id)
        //     ->orderBy('id')
        //     ->with('flashCards', 'unit', 'lessonFaqs', 'lessonReviews')
        //     ->first();

        $currentLesson = $this->lessonModel::where('id', $id)->with('unit')->first();

        $lesson = $this->lessonModel::where('id', '>', $id)
            ->whereHas('unit', fn ($q) => $q->where('id', $currentLesson->unit->id))
            ->orderBy('id')
            ->with(
                [
                    'flashCards',
                    'unit',
                    'lessonFaqs',
                    'lessonReviews'
                ]
            )
            ->first();

        if (is_null($lesson)) {
            $lesson = $currentLesson;
        }

        return view('Front.dashboard.pages.lesson-flashcards', compact('lesson'));
    }
    public function previous($id)
    {
        $currentLesson = $this->lessonModel::where('id', $id)->with('unit')->first();

        $lesson = $this->lessonModel::where('id', '<', $id)
            ->whereHas('unit', fn ($q) => $q->where('id', $currentLesson->unit->id))
            ->orderBy('id', 'desc')
            ->with(
                [
                    'flashCards',
                    'unit',
                    'lessonFaqs',
                    'lessonReviews'
                ]
            )
            ->first();

        if (is_null($lesson)) {
            $lesson = $currentLesson;
        }

        return view('Front.dashboard.pages.lesson-flashcards', compact('lesson'));
    }
}
