<?php

namespace App\Http\Repositories\Front;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Country;
use App\Models\CandlyLevel;
use App\Http\Traits\ImageTrait;
use App\Service\UserOtpService;
use App\Models\StudentCandlyLevel;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Laravel\Socialite\Facades\Socialite;
use App\Http\Interfaces\Front\AuthInterface;
use Illuminate\Validation\ValidationException;

class AuthRepository implements AuthInterface
{
    use ImageTrait;
    protected $userModel;

    public function __construct(User $usermodel)
    {
        $this->userModel = $usermodel;
    }

    public function registerPage()
    {
        // if (auth()->check()) {
        //     return redirect()->route('front.dashboard.index,1');
        // }
        if (auth()->check()) {
            return redirect('/');
        }
        return view('Front.Auth.signup');
    }

    public function register($request)
    {
        $user = $this->userModel::create([
            'email' => $request->email,
            'password' => Hash::make($request->password),
        ]);

        auth()->login($user);
        $candlylevel = CandlyLevel::first();
        $studentlevel = StudentCandlyLevel::create([
            'user_id' => $user->id,
            'candly_level_id' => $candlylevel->id,
        ]);
        return redirect()->route('auth.getName');
    }

    public function loginPage()
    {
        if (auth()->check()) {
            return redirect('/');
        }
        return view('Front.Auth.Login');
    }

    public function login($request)
    {
        $remember = $request->remember;
        if ($request->remember) {
            $remember = true;
        } else {
            $remember = false;
        }
        $credintials = $request->only('email', 'password', $remember);
        if (Auth::attempt($credintials)) {
            if (auth()->user()->active()) {
                return redirect()->route('front.dashboard.index', 1);
            } else {
                auth()->logout();
                return redirect()
                    ->back()
                    ->withErrors(['error' => 'your account is deactived please contact with support team']);
            }
        } else {
            return redirect()
                ->back()
                ->withErrors(['error' => 'You Don\'t Have Access To Login']);
        }
    }

    public function logout()
    {
        auth()->logout();
        Session::flush();
        return redirect()->route('login');
    }

    public function getName()
    {
        return view('Front.Auth.new-account-1');
    }

    public function storeName($request)
    {
        $request->validate([
            'name' => 'required',
        ]);
        auth()
            ->user()
            ->update([
                'name' => $request->name,
            ]);
        return redirect()->route('auth.getCountry');
    }

    public function getCountry()
    {
        $countries = Country::get();
        return view('Front.Auth.addcountry', compact('countries'));
    }

    public function storeCountry($request)
    {
        $request->validate([
            'country_id' => 'required',
        ]);

        auth()
            ->user()
            ->update([
                'country_id' => $request->country_id,
            ]);

        (new UserOtpService)->sendCode();

        return redirect()->route('auth.show-email-verification');
    }

    public function emailVerificationPage()
    {

        return view('Front.Auth.new-account-2');
    }

    public function emailVerificationStore($request)
    {
        $validated = $request->validate([
            'code' => 'required|string|size:7',
        ]);

        if (auth()->user()->otp_code !== $request->code) {
            throw ValidationException::withMessages(['code' => ['Code does not matches.']]);
        }

        auth()->user()->update([
            'otp_code' => null,
            'is_active' => true,
            'email_verified_at' => now(),
        ]);

        return redirect()->route('auth.uploadImg');
    }

    // public function sendNotification()
    // {
    //     $user = $this->userModel::find(auth()->user()->id);

    //     $user->sendEmailVerificationNotification();
    //     return view('Front.Auth.new-account-2');
    // }

    // public function acceptNotification($request)
    // {
    //     auth()
    //         ->user()
    //         ->update([
    //             'send_notification' => 1,
    //         ]);
    //     return redirect()->route('auth.uploadImg');
    // }
    public function uploadImg()
    {
        return view('Front.Auth.new-account-3');
    }

    public function storeImg($request)
    {
        if ($request->hasFile('image')) {
            $filename = time() . '.' . $request->image->extension();
            $images = $this->uploadImage($request->image, $filename, 'student');
            $image = 'images/student/' . $images;
        }
        auth()
            ->user()
            ->update([
                'image' => $image ?? '',
            ]);
        return redirect()->route('auth.levelQuiz');
    }
    public function levelQuiz()
    {
        return view('Front.Auth.new-account-4');
    }
}
