<?php
namespace App\Http\Repositories\Admin;


use App\Models\Test;
use App\Models\Level;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\TestInterface;
use App\Imports\TestImport;
use Maatwebsite\Excel\Facades\Excel;

class TestRepository implements TestInterface
{

    protected $testModel;
    protected $levelModel;
    public function __construct( Test $test, Level $level )
    {

        $this->testModel=$test;
        $this->levelModel =$level;

    }
    public function index(){
        $tests=  $this->testModel::get();

        return view('Admin.test.index',compact('tests'));
    }

    public function create(){
        $levels= $this->levelModel::get();
        return view('Admin.test.create',compact('levels'));

    }

    public function store($request)
    {
        $request->validate([
            'degree' => 'required|integer'
        ]);

        $test =  $this->testModel::create([

        'degree' => $request->degree,
        'level_id' =>$request->level_id

        ]);

        Alert::success('success', ' ٍTest Added Successfully');
        return redirect()->route('admin.test.index');
    }

    public function edit($id){
        $test=$this->testModel::find($id);
        $levels= $this->levelModel::get();

        return view('Admin.test.edit',compact('test','levels'));

    }

    public function update($request)
    {
        $request->validate([
            'degree' => 'required|integer'
        ]);

        $test=$this->testModel::find($request->id);
        $test->update([

            'degree' => $request->degree,
            'level_id' =>$request->level_id

        ]);


        Alert::success('success', ' ٍTest  updated Successfully');
        return redirect()->route('admin.test.index');
    }

    public function  destroy($id){
        $test=$this->testModel::find($id);

        if($test){
            $test->delete();
            return  1;
        }
        return  0;
    }

    public function import()
    {
        return view('Admin.test.import');
    }

    public function upimport($request)
    {
        request()->validate([
            'file' => 'required|mimes:xlsx,xls,csv',
        ]);

        Excel::import(new TestImport, $request->file('file')->store('files'));
        Alert::success('success', 'Imported Successfully');
        return redirect()->route('admin.test.index');

    }



}
