<?php
namespace App\Http\Repositories\Admin;

use App\Models\Setting;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\SettingInterface;
use App\Http\Traits\ImageTrait;

class SettingRepository implements SettingInterface{

    use ImageTrait;
    protected $settingModel;

    public function __construct(Setting $setting){
        $this->settingModel =$setting;
    }


    public function edit(){
        $setting= $this->settingModel::first();


        return view('Admin.setting.edit',compact('setting'));
    }
    public function update($request){

        if ($request->hasFile('logo')) {
            $filename = time() . '.' . $request->logo->extension();
            $logos =  $this->uploadImage($request->logo, $filename, 'setting');
            $logo= 'images/setting/'.$logos;

        }
        if ($request->hasFile('dash_logo')) {
            $filename = time() . '.' . $request->dash_logo->extension();
            $dash_logos =  $this->uploadImage($request->dash_logo, $filename, 'dashlogo');
            $dash_logo= 'images/dashlogo/'.$dash_logos;

        }
        $setting =  $this->settingModel::find($request->id);

        $setting->update([

            'logo'           =>  $logo ?? $setting->logo,
            'dash_logo'      =>  $dash_logo ?? $setting->dash_logo,
            'address'        =>  $request->address,
            'email'          =>  $request->email,
            'phone'          =>  $request->phone,
            'policy'         =>  $request->policy,
            'terms'          =>  $request->terms,
            'facebook'       =>  $request->facebook,
            'twitter'        =>  $request->twitter,
            'instagram'      =>  $request->instagram,
            'linkedin'       =>  $request->linkedin,
            'youtube'        =>  $request->youtube,
            'test_count'     =>  $request->test_count,
            'level_check'     =>  $request->level_check == 'on',
        ]);
        Alert::success('success', ' setting  updated Successfully');
        return redirect()->back();
    }


}
