<?php
namespace App\Http\Repositories\Admin;

use App\Models\Section;
use App\Models\SectionItem;
use App\Http\Traits\ImageTrait;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\SectionItemInterface;
use Illuminate\Support\Facades\Route;
class SectionItemRepository implements SectionItemInterface{
    use ImageTrait;
    protected $sectionitemModel;
    protected $sectionModel;

    public function __construct(SectionItem $sectionitem ,Section $section){
        $this->sectionModel =$section;
        $this->sectionitemModel =$sectionitem;
    }

    public function index()
    {
        if (Route::is('admin.sub.sectionitem*')) {
            $sectionitems =  $this->sectionitemModel::where('sub_section_item', '1')->with('section')->get();
            return view('Admin.subsectionitem.index',compact('sectionitems'));
        }

        $sectionitems =$this->sectionitemModel::where('sub_section_item', '0')->with('section')->get();
        return view('Admin.sectionitem.index',compact('sectionitems'));
    }
    public function create()
    {
        if (Route::is('admin.sub.sectionitem*')) {
            $sections =$this->sectionModel::where('sub_section', '1')->get();
            return view('Admin.subsectionitem.create',compact('sections'));
        }

        $sections =$this->sectionModel::where('sub_section', '0')->get();
        return view('Admin.sectionitem.create',compact('sections'));
    }

    public function store($request)
    {
        if ($request->hasFile('icon')) {
            $filename = time() . '.' . $request->icon->extension();
            $icons =  $this->uploadImage($request->icon, $filename, 'sectionitem');
            $icon= 'images/sectionitem/'.$icons;

        }

        $sectionitem =$this->sectionitemModel::create([
            'section_id'                => $request->section_id,
            'title'                     =>  $request->title,
            'description'               =>  $request->description,
            'icon'                      => $icon,
            'icon_color'                =>  $request->icon_color,
            'icon_background_color'     =>  $request->icon_background_color,
            'sub_section_item'          =>   Route::is('admin.sub.sectionitem*') ? '1' : '0'
        ]);

        Alert::success('success', ' SectionItem Added Successfully');
        if (Route::is('admin.sub.sectionitem*')) {
            return redirect()->route('admin.sub.sectionitem.index');
        }
        return redirect()->route('admin.sectionitem.index');
    }

    public function edit($id)
    {
        if (Route::is('admin.sub.section*')) {
            $sectionitem =$this->sectionitemModel::find($id);
            $sections =$this->sectionModel::where('sub_section', '1')->get();
            return view('Admin.subsectionitem.edit',compact('sections','sectionitem'));
        }

        $sectionitem =$this->sectionitemModel::find($id);
        $sections =$this->sectionModel::where('sub_section', '0')->get();
        return view('Admin.sectionitem.edit',compact('sections','sectionitem'));

    }


    public function update($request)
    {
        if ($request->hasFile('icon')) {
            $filename = time() . '.' . $request->icon->extension();
            $icons =  $this->uploadImage($request->icon, $filename, 'sectionitem');
            $icon= 'images/sectionitem/'.$icons;

        }
        $sectionitem =  $this->sectionitemModel::find($request->id);
        $sectionitem->update([
            'section_id'                => $request->section_id,
            'title'                     =>  $request->title,
            'description'               =>  $request->description,
            'icon'                      => $icon ?? $sectionitem->icon,
            'icon_color'                =>  $request->icon_color,
            'icon_background_color'     =>  $request->icon_background_color,
            'sub_section_item'          =>   Route::is('admin.sub.sectionitem*') ? '1' : '0'

        ]);
        Alert::success('success', ' SectionItem updated Successfully');
        if (Route::is('admin.sub.sectionitem*')) {
            return redirect()->route('admin.sub.sectionitem.index');
        }
        return redirect()->route('admin.sectionitem.index');
    }

    public function destroy($id){
        $sectionitem =$this->sectionitemModel::find($id);

        if($sectionitem){
            $sectionitem->delete();
            return  1;
        }

       return 0 ;

    }

}


