<?php 
namespace App\Http\Repositories\Admin;


use App\Models\Quiz;
use App\Models\Lesson;
use App\Models\QuizAnswer;
use App\Http\Traits\ImageTrait;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\QuizAnswerInterface;

class QuizAnswerRepository implements QuizAnswerInterface{

    use ImageTrait;

    protected $quizAnswerModel;
    public function __construct(  QuizAnswer $quizAnswer )
    {
     
        $this->quizAnswerModel =$quizAnswer;
       
    }
    
    public function create($questionid){
    
        
        return view('Admin.quizanswer.create',compact('questionid'));
    
    
    }
    
    public function store($request){
  
        $quizAnswer =  $this->quizAnswerModel::create([
             'question_id'   => $request->question_id,
             'answer'         => $request->answer,
             'is_correct'     =>isset($request->correct) ? 1 : 0,
             'status'         =>$request->status
         ]);
    
         if ($request->hasFile('image')) {
           
    
            
                $filename = time() . '.' . $request->image->extension();
            $images =  $this->uploadImage($request->image, $filename, 'quizanswerimage');
            $name= 'images/quizanswerimage/'.$images; 
            
            $quizAnswer->images()->create([
                'image' => $name,
                'type' => 'image',
            ]);
        }

        if ($request->hasFile('audio')) {
       

               
            $filename = time() . '.' . $request->audio->extension();
        $audios =  $this->uploadImage($request->audio, $filename, 'quizaansweraudio');
        $name= 'images/quizaansweraudio/'.$audios; 
        
        $quizAnswer->audios()->create([
            'audio' => $name,
            'type' => 'audio',
        ]);
        }
    
        Alert::success('success', ' ٍAnswer addes Successfully');
        return redirect()->route('admin.quizquestion.show', $quizAnswer ->question_id);
    }
    public function edit($id){
      
        $quizAnswer= $this->quizAnswerModel::find($id);
       
        return view('Admin.quizanswer.edit',compact('quizAnswer'));
    
    }
    
    
    public function update($request){
       
        $answer=$this->quizAnswerModel::find($request->id);
        $answer->update([
    
           'answer'=> $request->answer,
           'is_correct'=>isset($request->correct) ? 1 : 0,
           'status'         =>(!is_null($request->status) ? $request->status :  0)   
          ]);
    
          
        if (isset($request->image)) {
            $answer->images()->delete();
    
        $filename = time() . '.' . $request->image->extension();
        $images =  $this->uploadImage($request->image, $filename, 'quizanswerimage');
        $name= 'images/quizanswerimage/'.$images; 
        
        $answer->images()->create([
            'image' => $name,
            'type' => 'image',
        ]); }
        if ($request->hasFile('audio')) {
       

            $answer->audios()->delete();
         $filename = time() . '.' . $request->audio->extension();
     $audios =  $this->uploadImage($request->audio, $filename, 'quizaansweraudio');
     $name= 'images/quizaansweraudio/'.$audios; 
     
     $answer->audios()->create([
         'audio' => $name,
         'type' => 'audio',
     ]);
    
    }
    
         
        Alert::success('success', ' ٍAnswer updated Successfully');
        return redirect()->route('admin.quizquestion.show',$answer->question_id);
    }
    
    public function  destroy($id){
     
        $answer=$this->quizAnswerModel::find($id);
        if($answer){
           if($answer->images){$answer->images->delete();} 
            $answer->delete();
            
        }
      return redirect()->back();
    }
    


}