<?php

namespace App\Http\Repositories\Admin;

use App\Models\GuideCategory;
use App\Http\Traits\ImageTrait;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\GuidesCategoryInterface;

class GuidesCategoryRepository implements GuidesCategoryInterface
{



    protected $guidesCategoryModel;


    public function __construct(GuideCategory $guidesCategory)
    {
        $this->guidesCategoryModel = $guidesCategory;
    }
    public function index()
    {
        $guidecategories =  $this->guidesCategoryModel::get();
        return view('Admin.guidecategory.index', compact('guidecategories'));
    }
    public function create()
    {
        return view('Admin.guidecategory.create');
    }

    public function store($request)
    {
        $guidesCategory =  $this->guidesCategoryModel::create([
            'title'             =>  $request->title,
            'description'       =>  $request->description
        ]);
        Alert::success('success', ' guidesCategory Added Successfully');
        return redirect()->route('admin.guidecategory.index');
    }

    public function edit($id)
    {
        $guidecategory = $this->guidesCategoryModel::find($id);
        return view('Admin.guidecategory.edit', compact('guidecategory'));
    }

    public function update($request)
    {
        $guidecategory =  $this->guidesCategoryModel::find($request->id);
        $guidecategory->update([
            'title'             =>  $request->title,
            'description'       =>  $request->description,
        ]);
        Alert::success('success', ' guide Category  updated Successfully');
        return redirect()->route('admin.guidecategory.index');
    }

    public function  destroy($id)
    {
        $guidesCategory = $this->guidesCategoryModel::find($id);

        if ($guidesCategory) {
            $guidesCategory->delete();
            return  1;
        }

        return 0;
    }
}
