<?php

namespace App\Http\Repositories\Admin;

use App\Models\FaqCategory;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\FaqCategoryInterface;

class FaqCategoryRepository implements FaqCategoryInterface
{

    protected $faqcategoryModel;

    public function __construct(FaqCategory $faqcategory)
    {

        $this->faqcategoryModel = $faqcategory;
    }

    public function index()
    {
        $faqcategories = $this->faqcategoryModel::get();
        return view('Admin.faqcategory.index', compact('faqcategories'));
    }

    public function create()
    {
        return view('Admin.faqcategory.create');
    }

    public function store($request)
    {
        $faqcategory = $this->faqcategoryModel::create([

            'title' => $request->title

        ]);

        Alert::success('success', 'FaqCategory Added Successfully');
        return redirect()->route('admin.faqcategory.index');
    }

    public function edit($id)
    {
        $faqcategory = $this->faqcategoryModel::find($id);
        return view('Admin.faqcategory.edit', compact('faqcategory'));
    }

    public function update($request)
    {
        $faqcategory = $this->faqcategoryModel::find($request->id);

        $faqcategory->update([
            'title' => $request->title
        ]);
        Alert::success('success', 'FaqCategory updated Successfully');
        return redirect()->route('admin.faqcategory.index');
    }

    public function destroy($id)
    {
        $faqcategory = $this->faqcategoryModel::find($id);

        if ($faqcategory) {

            $faqcategory->delete();
            return  1;
        }
        return 0;
    }
}
