<?php

namespace App\Http\Repositories\Admin;

use App\Http\Interfaces\Admin\DashboardInterface;
use App\Models\Admin;
use App\Models\User;
use App\Models\Course;
use App\Models\Unit;
use App\Models\Level;
use App\Models\Lesson;
use App\Models\GuideCategory;
use App\Models\GuideDetail;
use App\Models\Download;
use App\Models\QuizQuestion;
use GuzzleHttp\Psr7\Request;
use RealRashid\SweetAlert\Facades\Alert;

class DashboardRepository implements DashboardInterface
{
    protected $adminModel;
    protected $userModel;
    protected $courseModel;
    protected $unitModel;
    protected $levelModel;
    protected $lessonModel;
    protected $guideCategoryModel;
    protected $guideDetailModel;
    protected $downloadModel;
    protected $questionModel;

    public function __construct(
        Admin           $admin,
        User            $user,
        Course          $course,
        Unit            $unit,
        Level           $level,
        Lesson          $lesson,
        GuideCategory   $guideCategory,
        GuideDetail     $guideDetail,
        QuizQuestion    $question,
        Download        $download
    ){
        $this->adminModel           = $admin;
        $this->userModel            = $user;
        $this->courseModel          = $course;
        $this->unitModel            = $unit;
        $this->levelModel           = $level;
        $this->lessonModel          = $lesson;
        $this->guideCategoryModel   = $guideCategory;
        $this->guideDetailModel     = $guideDetail;
        $this->downloadModel        = $download;
        $this->questionModel        = $question;
    }

    public function index()
    {
        $data['admins']            = $this->adminModel->get();
        $data['students']          = $this->userModel->get();
        $data['courses']           = $this->courseModel->get();
        $data['units']             = $this->unitModel->get();
        $data['levels']            = $this->levelModel->get();
        $data['lessons']           = $this->lessonModel->get();
        $data['GuideCategories']   = $this->guideCategoryModel->get();
        $data['GuideDetails']      = $this->guideDetailModel->get();
        $data['downloads']         = $this->downloadModel->get();
        $data['questions']         = $this->questionModel->get();

        return view('Admin.index', $data);
    }

    public function search($request)
    {
        if ($request['typeSearch'] == 'admin') {
            $query =  $this->adminModel::query();

            if($request->has('title'))
            {
                $query->where('name', 'like', "%" . $request->title . "%");
            }

            $data['admins'] =  $query->get();
            $getSearch      =  $query->get(['id', 'name']);

        }elseif ($request['typeSearch'] == 'student') {
            $query =  $this->userModel::query();

            if($request->has('title'))
            {
                $query->where('name', 'like', "%" . $request->title . "%");
            }

            $data['students'] =  $query->get();
            $getSearch      =  $query->get(['id', 'name']);

        }elseif ($request['typeSearch'] == 'course') {
            $query =  $this->courseModel::query();

            if($request->has('title'))
            {
                $query->where('title', 'like', "%" . $request->title . "%");
            }
            $data['courses'] =  $query->get();
            $getSearch      =  $query->get(['id', 'title']);

        }elseif ($request['typeSearch'] == 'level') {
            $query =  $this->levelModel::query();

            if($request->has('title'))
            {
                $query->where('number', 'like', "%" . $request->title . "%");
            }
            $data['levels'] =  $query->get();
            $getSearch      =  $query->get(['id', 'number']);
        }elseif ($request['typeSearch'] == 'unit') {
            $query =  $this->unitModel::query();

            if($request->has('title'))
            {
                $query->where('title', 'like', "%" . $request->title . "%");
            }
            $data['units']  =  $query->with('level')->get();
            $getSearch      =  $query->get(['id', 'title']);

        }elseif ($request['typeSearch'] == 'lesson') {
            $query =  $this->lessonModel::query();

            if($request->has('title'))
            {
                $query->where('title', 'like', "%" . $request->title . "%");
            }
            $data['lessons'] =  $query->get();
            $getSearch       =  $query->get(['id', 'title']);
        }else{
            $data       = [];
            $getSearch  =  [];
        }

        if (count($data) >= 1) {
            if ($request['checkPage'] == 1) {
                return view('Admin.'.$request['typeSearch'].'.index', $data);
            }
            return response()->json($getSearch, 200);
        }else{
            Alert::warning('errors', 'Not Found Search');
            return back();
        }
    }
}
