<?php

namespace App\Http\Repositories\Admin;

use App\Models\Course;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\CourseInterface;
use App\Http\Traits\ImageTrait;

class CourseRepository implements CourseInterface
{
    use ImageTrait;
    protected $courseModel;
    public function __construct(Course $course)
    {

        $this->courseModel = $course;
    }

    public function index()
    {
        $request = \request();
        $courses =  $this->allSearch($request);
        return view('Admin.course.index', compact('courses'));
    }

    public function allSearch($request)
    {
        // dd($request->all());
        $query = $this->courseModel::query();
        if($request->has('title'))
        {
            $query->where('title', 'LIKE', "%{$request->title}%");
        }
        $courses =  $query->get();
        return $courses;
    }
    public function search($request)
    {
        // dd($request->all());
        $query =  $this->courseModel::query();
        if($request->has('title'))
        {
            $query->where('title', 'like', "%" . $request->title . "%");
        }
        $courses =  $query->get(['id', 'title']);
        return response()->json($courses, 200);
    }


    public function create()
    {
        return view('Admin.course.create');
    }

    public function store($request)
    {
        if ($request->hasFile('icon')) {
            $filename = time() . '.' . $request->icon->extension();
            $icons =  $this->uploadImage($request->icon, $filename, 'course');
            $icon = 'images/course/' . $icons;
        }
        $course =  $this->courseModel::create([

            'title'                     => $request->title,
            'code'                      => $request->code,
            // 'type'                      => $request->type,
            // 'price'                     => $request->price,
            // 'discount'                  => $request->discount,
            'icon'                      => $icon,
            'background_color'          => $request->background_color,
            'copy_write'                => $request->copy_write

        ]);
        Alert::success('success', ' CourseAdded Successfully');
        return redirect()->route('admin.course.index');
    }

    public function edit($id)
    {
        $course = $this->courseModel::find($id);
        return view('Admin.course.edit', compact('course'));
    }


    public function update($request)
    {
        if ($request->hasFile('icon')) {
            $filename = time() . '.' . $request->icon->extension();
            $icons =  $this->uploadImage($request->icon, $filename, 'course');
            $icon = 'images/course/' . $icons;
        }
        $course = $this->courseModel::find($request->id);
        $course->update([

            'title'                     => $request->title,
            'code'                      => $request->code,
            'type'                      => $request->type,
            'price'                     => $request->price,
            'discount'                  => $request->discount,
            'icon'                      => $icon  ?? $course->icon,
            'background_color'          => $request->background_color,
            'copy_write'                => $request->copy_write

        ]);
        Alert::success('success', ' Course  updated Successfully');
        return redirect()->route('admin.course.index');
    }

    public function  destroy($id)
    {
        $course = $this->courseModel::find($id);

        if ($course) {
            $course->delete();
        }
        return  1;
    }
}
