<?php
namespace App\Http\Repositories\Admin;

use App\Models\Course;
use App\Models\CourseGoal;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\CourseGoalInterface;

class CourseGoalRepository implements CourseGoalInterface{

    protected $coursegoalModel;
    protected $courseModel;

    public function __construct(CourseGoal $coursegoal ,Course $course){

        $this->courseModel=$course;
        $this->coursegoalModel =$coursegoal;
        
    }

    public function index(){
        $coursegoals =$this->coursegoalModel::with('course')->get();
        return view('Admin.coursegoal.index',compact('coursegoals'));
    }

    public function create(){
        $courses =$this->courseModel::get();
        return view('Admin.coursegoal.create',compact('courses'));
    }

    public function store($request){
        $coursegoal =$this->coursegoalModel::create([
            'goal' => $request->goal,
            'course_id' => $request->course_id

        ]);

        Alert::success('success', ' CourseGoal Added Successfully');
        return redirect()->route('admin.coursegoal.index');
    }

    public function edit($id){
        $coursegoal =$this->coursegoalModel::find($id);
        $courses =$this->courseModel::get();
        return view('Admin.coursegoal.edit',compact('coursegoal','courses'));  

    }

    public function update($request){
        $coursegoal =$this->coursegoalModel::find($request->id);
        $coursegoal->update([
            'goal' => $request->goal,
            'course_id' => $request->course_id

        ]);

        Alert::success('success', ' CourseGoal updated Successfully');
        return redirect()->route('admin.coursegoal.index');

    }

    public function destroy($id){
        $coursegoal =$this->coursegoalModel::find($id);

        if($coursegoal){
            $coursegoal->delete();
            return  1;
        }
        return  0;

    }
    
}