<?php
namespace App\Http\Repositories\Admin;

use App\Models\Country;
use App\Imports\CountryImport;
use Illuminate\Database\Eloquent\Model;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\CountryInterface;
use Maatwebsite\Excel\Facades\Excel;

class CountryRepository implements CountryInterface{

    protected $countryModel;
    public function __construct(Country $country)
    {

        $this->countryModel=$country;
    }
    public function index(){
        $countrys=  $this->countryModel::get();
        return view('Admin.country.index',compact('countrys'));
    }

    public function create(){
        return view('Admin.country.create');

    }

    public function store($request){
        $request->validate([
            'country' => 'required'
         ]);
        $country =  $this->countryModel::create([

          'country'                     => $request->country,


        ]);
        Alert::success('success', ' countryAdded Successfully');
        return redirect()->route('admin.country.index');
    }

    public function edit($id){
        $country=$this->countryModel::find($id);
        return view('Admin.country.edit',compact('country'));

    }


    public function update($request){
        $request->validate([
            'country' => 'required'
         ]);
        $country=$this->countryModel::find($request->id);
        $country->update([

            'country'                     => $request->country,


          ]);
        Alert::success('success', ' country  updated Successfully');
        return redirect()->route('admin.country.index');
    }

    public function  destroy($id){
        $country=$this->countryModel::find($id);

        if($country){
            $country->delete();
        }
        return  1;
    }

    public function import()
    {
        return view('Admin.country.import');
    }

    public function upimport($request)
    {
        request()->validate([
            'file' => 'required|mimes:xlsx,xls,csv',
        ]);

        Excel::import(new CountryImport, $request->file('file')->store('files'));
        Alert::success('success', 'Imported Successfully');
        return redirect()->route('admin.country.index');
    }
}
