<?php
namespace App\Http\Repositories\Admin;

use App\Models\Contact;
use App\Http\Interfaces\Admin\ContactInterface;

class ContactRepository implements ContactInterface{
    protected $contactModel;

    public function __construct(Contact $contact){

        $this->contactModel=$contact;
    }

    public function index(){
        $contacts =$this->contactModel::get();
        return view('Admin.contact.index',compact('contacts'));
    }

    public function destroy($id){
        $contact =$this->contactModel::find($id);

        if($contact){
            $contact->delete();
            return  1;
        }
        return  0;
    }
}