<?php

namespace App\Http\Livewire;

use Carbon\Carbon;
use Livewire\Component;
use App\Models\QuizAnswer;
use App\Models\CandlyLevel;
use App\Models\QuizStudent;
use App\Models\QuizQuestion;
use App\Models\StudentCandlyLevel;
use App\Models\QuizStudentQuestion;

class Quiz extends Component
{
    protected $listeners = ['goback'];
    public array $answered = [];

    public
        $quiz,
        $studentquiz_id,
        $data,
        $counter = 0,
        $questioncount = 0,
        $plusprogress,
        $questions = [],
        $progress = 0,
        $add = 0,
        $anss = [],
        $matchingcount = 0,
        $result = 0,
        $showColor = false,
        $answerColor = false,
        $answer_id,
        $questionid,
        $rightanswer,
        $wronganswer = false,
        $matchans = "",
        $matchques = "",

        $checkContainer = false,
        $checkerAnswerId,
        $checkerAnswerAnswer,
        $checkerCounterId,

        $color = [];

    public function mount(
        $id,
        $studentquiz
    ) {

        $this->studentquiz_id = $studentquiz;
        $this->quiz = QuizQuestion::with('quiz', 'answers')->where('quiz_id', $id)->inRandomOrder()->limit(10)->distinct()->get();
    }

    public function render()
    {
        $this->data = $this->quiz;
        $this->questioncount = $this->data->count();
        $this->add = 100 / $this->questioncount;

        $this->progress = $this->add * ($this->counter + 1);

        return view('livewire.quiz', [$this->data]);
    }

    public function chooseAnswer(
        $questionid,
        $answer,
        $answerid
    ) {

        $this->showColor = true;
        $this->answer_id = $answerid;

        if (in_array($questionid, $this->answered)) {
            unset($this->answer_id);
            return;
        }

        $this->answered[] = $questionid;

        $rightanswer = QuizAnswer::where([['question_id', '=', $questionid], ['is_correct', '=', 1]])->first();
        $this->rightanswer = $rightanswer->id;

        if ($rightanswer->id ==   $answerid) {
            $this->answerColor = true;
        } else {
            $this->wronganswer = true;
        }

        if (!($rightanswer->question->type == 'matchingpairs')) {
            QuizStudentQuestion::create([
                'user_id' => auth()->user()->id,
                'quiz_student_id' => $this->studentquiz_id,
                'question_id' => $questionid,
                'answer_id' => $answerid,
                'answer'    => $answer,
                'degree'     => (($rightanswer->id == $answerid) ? 1 : 0),

            ]);
        }
        unset($this->answer_id);
        $this->checkContainer = false;
    }

    public function nextQuestion()
    {

        $this->showColor = false;
        $this->wronganswer = false;
        $this->answerColor = false;
        $this->progress = $this->add * ($this->counter + 1);

        if ($this->counter < $this->questioncount - 1) {
            $this->counter++;
        } else {
            $studentdegree = QuizStudentQuestion::where('quiz_student_id', $this->studentquiz_id)->sum('degree');
            $studentquiz = QuizStudent::find($this->studentquiz_id);
            $studentquiznew = QuizStudent::where([['user_id', auth()->user()->id], ['quiz_id', $studentquiz->quiz_id]])->get();

            $studentquiz->update([
                'total_degree' => $studentdegree,
                'status'      => 1,
                'medal'       => ($studentdegree == 10 ? 1 : 0),

            ]);
            $user = auth()->user();
            $date = Carbon::parse($user->streak_updated);
            $created = Carbon::parse($user->created_at);

            if (($date->diffInDays(Carbon::now())) !== 0  ||  $date == $created) {
                $user->update([
                    'streak' => $user->streak + 1,
                    'streak_updated' => date("Y-m-d H:i:s"),
                ]);
            };

            if ($studentquiznew->count()  == 1) {
                $studentlevel = StudentCandlyLevel::where('user_id', auth()->user()->id)->latest()->firstOr(function () {
                    StudentCandlyLevel::create([
                        'user_id' => auth()->user()->id,
                        'candly_level_id' => CandlyLevel::first()->id,
                    ]);
                });


                $candlylevel = CandlyLevel::where('id', '>', $studentlevel->candly_level_id)->orderBy('id')->first();

                if ($studentlevel->xp_points == $studentlevel->candlylevel->xp_points) {
                    $studentlevel = StudentCandlyLevel::create([
                        'user_id' => $user->id,
                        'candly_level_id' => $candlylevel->id,
                        'xp_points' =>  5

                    ]);
                    $studentlevel->update([
                        'status' => 1
                    ]);
                } else {
                    $studentlevel->update([
                        'xp_points' => $studentlevel->xp_points + 5
                    ]);
                }
            }

            if ($studentdegree == 10) {
                $studentlevel = StudentCandlyLevel::where('user_id', auth()->user()->id)->latest()->firstOr(function () {
                    StudentCandlyLevel::create([
                        'user_id' => auth()->user()->id,
                        'candly_level_id' => CandlyLevel::first()->id,
                    ]);
                });

                $candlylevel = CandlyLevel::where('id', '>', $studentlevel->candly_level_id)->orderBy('id')->first();

                if ($studentlevel->xp_points == $studentlevel->candlylevel->xp_points) {
                    $studentlevel = StudentCandlyLevel::create([
                        'user_id' => $user->id,
                        'candly_level_id' => $candlylevel->id,
                        'xp_points' =>  3
                    ]);
                    $studentlevel->update([
                        'status' => 1
                    ]);
                } else {
                    $studentlevel->update([
                        'xp_points' => $studentlevel->xp_points + 3
                    ]);
                }
            }

            return redirect()->route('front.dashboard.quizresult', $studentquiz->id);
        }
    }

    public function matchingPairs(
        $question_id,
        $question
    ) {

        $this->matchques = $question;

        $quetions = QuizQuestion::with('answer')->find($question_id);

        $ques = explode(',', $quetions->question);
        $this->matchingcount++;

        foreach ($ques as $key => $q) {
            if ($q  == $question) {
                $this->color[] = mt_rand(0, 0xFFFFF);
                $this->questions = $key;
            }
        }
    }

    public function answer(
        $question_id,
        $answer,
        $answer_id
    ) {

        $this->matchans = $answer;

        $quizanswer = QuizAnswer::with('question')->find($answer_id);
        $qanswer = QuizAnswer::where('question_id', $question_id)->get();

        if ($quizanswer->status == $this->questions) {
            $this->anss[]++;
        }

        if ($this->matchingcount == count($qanswer)) {

            $this->showColor = true;
            QuizStudentQuestion::create([
                'user_id' => auth()->user()->id,
                'quiz_student_id' => $this->studentquiz_id,
                'question_id' => $question_id,
                'answer_id' => $answer_id,
                'answer'    => $answer,
                'degree'     => (array_sum($this->anss) == count($qanswer)  ? 1 : 0),

            ]);

            if (array_sum($this->anss) == count($qanswer)) {
                $this->answerColor = true;
            } else {
                $this->wronganswer = true;
            }

            $this->anss = [];
            $this->matchingcount = 0;
        }
        unset($this->answer_id);
    }

    public function back(
        $id
    ) {
        $this->dispatchBrowserEvent('swal:confirm', [
            'type' => 'warning',
            'title' => 'Are you sure you are ready to leave? Your quiz progress will be lost.',
            'text'  => '',
            'id' => $id
        ]);
    }

    public function goback(
        $id
    ) {
        return redirect()->route('front.dashboard.lessonFlash', $id);
    }

    public function setAnswer(
        $checkerCounterId,
        $checkerAnswerAnswer,
        $checkerAnswerId,
    ) {
        $this->checkerAnswerId = $checkerAnswerId;
        $this->checkerAnswerAnswer = $checkerAnswerAnswer;
        $this->checkerCounterId = $checkerCounterId;

        $this->checkContainer = true;
    }
}
