<?php

namespace App\Http\Livewire;

use App\Models\Admin;
use App\Models\Message;
use Livewire\Component;

class Chat extends Component
{

    public $messageText;
    public function render()
    {

        
        
        $messages=Message::get();
       
        return view('livewire.chat', compact('messages'));
    }

    public function sendMessage()
    { 
       
        $user=auth()->user();
        $admin= Admin::first();

        $user->sendMessages()->create([
            'message_text' => $this->messageText,
            'reciver_id' => $admin->id,
            'reciver_type' => get_class($admin),
        ]);
     

        $this->reset('messageText');
    }
}
