<?php

namespace App\Http\Controllers\Front;

use App\Models\Subscribe;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use RealRashid\SweetAlert\Facades\Alert;
use App\Service\TapPaymentService\TapService;
use App\Http\Interfaces\Front\SubscribeInterface;
use App\Http\Requests\Front\Subscribe\SubscribeRequest;

class SubscribeController extends Controller
{
    private SubscribeInterface $subscribeRepository;

    public function __construct(SubscribeInterface $subscribeRepository)
    {
        $this->subscribeRepository = $subscribeRepository;
    }

    public function store(SubscribeRequest $request, TapService $tapService)
    {

        $subscribe = $this->subscribeRepository->store($request->validated());

        if ($subscribe->paid_amount == 0) { // free package
            $subscribe->update(['status' => 1]);
            return redirect()->route('front.dashboard.index', 0)->with('success', 'You have successfully subscribed.');
        }

        $user = auth()->user();

        $response = $tapService->customerDetails(
            first_name: $user->name,
            email: $user->email,
        )
            ->amount($subscribe->paid_amount)
            ->currency()
            ->redirect(route('front.dashboard.subscribe-redirect'))
            ->charge();

        $subscribe->update(['ref_code' => $response->id]);

        return redirect()->to($tapService->payUrl());
    }

    public function subscribeRedirect(Request $request, TapService $tapService)
    {
        $invoice = $tapService->getCharge($request->tap_id);

        if (!$tapService->isSuccessfullyPayed()) {
          
            return redirect()->route('front.dashboard.index', 0)->with('error', 'Payment not completed, please try again.');
        }

        $subscribe = Subscribe::where(['ref_code' => $invoice->id, 'status' => false])->firstOrFail();
        $subscribe->update(['status' => true]); // has observer
       // $subscribe->seller->increment('counter');
        return redirect()->route('front.dashboard.index', 0)->with('success', 'You have successfully subscribed.');
    }
}
