<?php

namespace App\Http\Controllers\Admin;


use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Interfaces\Admin\UnitInterface;
use App\Http\Requests\Admin\Units\CreateUnitRequest;
use App\Http\Requests\Admin\Units\UpdateUnitRequest;
use App\Models\Unit;

class UnitController extends Controller
{
    protected $unitInterface;

    public function __construct(UnitInterface $unitInterface)
    {
        $this->unitInterface =$unitInterface;
    }

    public function index(){
        return $this->unitInterface->index();
    }

    // public function show($id)
    // {
    //     $units =  Unit::where('level_id', $id)->with('level')->get();
    //          return view('Admin.unit.index',compact('units', 'id'));

    // }

    public function search(Request $request)
    {
        return $this->unitInterface->search($request);
    }

    public function create(){
         return $this->unitInterface->create();
    }

    public function store(CreateUnitRequest $request){
         return $this->unitInterface->store($request);
    }

    public function edit($id){
         return $this->unitInterface->edit($id);
    }

    public function update(UpdateUnitRequest $request){
         return $this->unitInterface->update($request);
    }

    public function  destroy($id){
         return $this->unitInterface->destroy($id);
    }
}
