<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Interfaces\Admin\SectionItemInterface;
use App\Http\Requests\Admin\SectionItem\CreatSectionRequest;
use App\Http\Requests\Admin\SectionItem\UpdateSectionRequest;

class SectionItemController extends Controller
{
    protected $sectionitemInterface;

    public function __construct(SectionItemInterface $sectionitemInterface){
        $this->sectionitemInterface =$sectionitemInterface;
    }

    public function index(){
        return $this->sectionitemInterface->index();
    }

    public function create(){
        return $this->sectionitemInterface->create();
    }

    public function store(CreatSectionRequest $request){
        return $this->sectionitemInterface->store($request);
    }

    public function edit($id){
        return $this->sectionitemInterface->edit($id);
    }

    public function update(UpdateSectionRequest $request){
        return $this->sectionitemInterface->update($request);
    }

    public function destroy($id){
        return $this->sectionitemInterface->destroy($id);
    }

}
