<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Interfaces\Admin\PageInterface;
use App\Http\Requests\Admin\Page\CreatePageRequest;
use App\Http\Requests\Admin\Page\UpdatePageRequest;

class PageController extends Controller
{
  protected $pageInterface;

  public function __construct(PageInterface $pageInterface)
   {
      $this->pageInterface =$pageInterface;

   }

  public function index(){
    return $this->pageInterface->index();
   }

  public function create(){
    return $this->pageInterface->create();
  }

  public function store(CreatePageRequest $request){
    return $this->pageInterface->store($request);

  }

  public function edit($id){
    return $this->pageInterface->edit($id);
  }

  public function update(UpdatePageRequest $request){
    return $this->pageInterface->update($request);
  }

  public function destroy($id){
    return $this->pageInterface->destroy($id);
  }


}
