<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Repositories\Admin\CourseQuizRepository;
use App\Http\Requests\Admin\Quiz\CreateQuizRequest;
use App\Http\Requests\Admin\Quiz\UpdateQuizRequest;

class CourseQuizController extends Controller
{
    protected $courseQuizInterface;

    public function __construct(CourseQuizRepository $courseQuizInterface)
    {
        $this->courseQuizInterface=$courseQuizInterface;
    }
    public function index($lessonId){
       return  $this->courseQuizInterface->index($lessonId);
    }

    public function create($id){
        return  $this->courseQuizInterface->create($id);
    }

    public function store( CreateQuizRequest $request){
        return  $this->courseQuizInterface->store($request);
    }

    public function edit($id){
        return  $this->courseQuizInterface->edit($id);
    }

    public function update( UpdateQuizRequest $request){
        return  $this->courseQuizInterface->update($request);
    }


    public function destroy($id){
        return  $this->courseQuizInterface->destroy($id);
    }
}
